/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BlazeBurnerHandler {
    @SubscribeEvent
    public static void onThrowableImpact(ProjectileImpactEvent.Throwable event) {
        BlazeBurnerHandler.thrownEggsGetEatenByBurner(event);
        BlazeBurnerHandler.splashExtinguishesBurner(event);
    }

    public static void thrownEggsGetEatenByBurner(ProjectileImpactEvent.Throwable event) {
        if (!(event.getThrowable() instanceof EggEntity)) {
            return;
        }
        if (event.getRayTraceResult().func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        TileEntity tile = event.getThrowable().field_70170_p.func_175625_s(new BlockPos(event.getRayTraceResult().func_216347_e()));
        if (!(tile instanceof BlazeBurnerTileEntity)) {
            return;
        }
        event.setCanceled(true);
        event.getThrowable().func_213317_d(Vector3d.field_186680_a);
        event.getThrowable().func_70106_y();
        World world = event.getThrowable().field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        BlazeBurnerTileEntity heater = (BlazeBurnerTileEntity)tile;
        if (heater.activeFuel != BlazeBurnerTileEntity.FuelType.SPECIAL) {
            heater.activeFuel = BlazeBurnerTileEntity.FuelType.NORMAL;
            heater.remainingBurnTime = MathHelper.func_76125_a((int)(heater.remainingBurnTime + 80), (int)0, (int)10000);
            heater.updateBlockState();
            heater.notifyUpdate();
        }
        AllSoundEvents.BLAZE_MUNCH.playOnServer(world, heater.func_174877_v());
    }

    public static void splashExtinguishesBurner(ProjectileImpactEvent.Throwable event) {
        if (event.getThrowable().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getThrowable() instanceof PotionEntity)) {
            return;
        }
        PotionEntity entity = (PotionEntity)event.getThrowable();
        if (event.getRayTraceResult().func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        ItemStack stack = entity.func_184543_l();
        Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
        if (potion == Potions.field_185230_b && PotionUtils.func_185189_a((ItemStack)stack).isEmpty()) {
            BlockRayTraceResult result = (BlockRayTraceResult)event.getRayTraceResult();
            World world = entity.field_70170_p;
            Direction face = result.func_216354_b();
            BlockPos pos = result.func_216350_a().func_177972_a(face);
            BlazeBurnerHandler.extinguishLitBurners(world, pos, face);
            BlazeBurnerHandler.extinguishLitBurners(world, pos.func_177972_a(face.func_176734_d()), face);
            for (Direction face1 : Direction.Plane.HORIZONTAL) {
                BlazeBurnerHandler.extinguishLitBurners(world, pos.func_177972_a(face1), face1);
            }
        }
    }

    private static void extinguishLitBurners(World world, BlockPos pos, Direction direction) {
        BlockState state = world.func_180495_p(pos);
        if (AllBlocks.LIT_BLAZE_BURNER.has(state)) {
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            world.func_175656_a(pos, AllBlocks.BLAZE_BURNER.getDefaultState());
        }
    }
}

