/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gauge;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeBlock;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.MatrixStacker;
import java.util.ArrayList;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public abstract class GaugeInstance
extends ShaftInstance
implements IDynamicInstance {
    protected final ArrayList<DialFace> faces = new ArrayList(2);
    protected MatrixStack ms;

    protected GaugeInstance(MaterialManager<?> dispatcher, KineticTileEntity tile) {
        super(dispatcher, tile);
        GaugeTileEntity gaugeTile = (GaugeTileEntity)tile;
        GaugeBlock gaugeBlock = (GaugeBlock)this.blockState.func_177230_c();
        Instancer dialModel = this.getTransformMaterial().getModel(AllBlockPartials.GAUGE_DIAL, this.blockState);
        Instancer<ModelData> headModel = this.getHeadModel();
        this.ms = new MatrixStack();
        MatrixStacker msr = MatrixStacker.of(this.ms);
        msr.translate((Vector3i)this.getInstancePosition());
        float progress = MathHelper.func_219799_g((float)AnimationTickHolder.getPartialTicks(), (float)gaugeTile.prevDialState, (float)gaugeTile.dialState);
        for (Direction facing : Iterate.directions) {
            if (!gaugeBlock.shouldRenderHeadOnFace(this.world, this.pos, this.blockState, facing)) continue;
            DialFace face = this.makeFace(facing, (Instancer<ModelData>)dialModel, headModel);
            this.faces.add(face);
            face.setupTransform(msr, progress);
        }
    }

    private DialFace makeFace(Direction face, Instancer<ModelData> dialModel, Instancer<ModelData> headModel) {
        return new DialFace(face, (ModelData)dialModel.createInstance(), (ModelData)headModel.createInstance());
    }

    public void beginFrame() {
        GaugeTileEntity gaugeTile = (GaugeTileEntity)this.tile;
        if (MathHelper.func_180185_a((float)gaugeTile.prevDialState, (float)gaugeTile.dialState)) {
            return;
        }
        float progress = MathHelper.func_219799_g((float)AnimationTickHolder.getPartialTicks(), (float)gaugeTile.prevDialState, (float)gaugeTile.dialState);
        MatrixStacker msr = MatrixStacker.of(this.ms);
        for (DialFace faceEntry : this.faces) {
            faceEntry.updateTransform(msr, progress);
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, this.faces.stream().flatMap(Couple::stream));
    }

    @Override
    public void remove() {
        super.remove();
        this.faces.forEach(rec$ -> ((DialFace)rec$).delete());
    }

    protected abstract Instancer<ModelData> getHeadModel();

    public static class Stress
    extends GaugeInstance {
        public Stress(MaterialManager<?> dispatcher, KineticTileEntity tile) {
            super(dispatcher, tile);
        }

        @Override
        protected Instancer<ModelData> getHeadModel() {
            return this.getTransformMaterial().getModel(AllBlockPartials.GAUGE_HEAD_STRESS, this.blockState);
        }
    }

    public static class Speed
    extends GaugeInstance {
        public Speed(MaterialManager<?> dispatcher, KineticTileEntity tile) {
            super(dispatcher, tile);
        }

        @Override
        protected Instancer<ModelData> getHeadModel() {
            return this.getTransformMaterial().getModel(AllBlockPartials.GAUGE_HEAD_SPEED, this.blockState);
        }
    }

    private class DialFace
    extends Couple<ModelData> {
        Direction face;

        public DialFace(Direction face, ModelData first, ModelData second) {
            super(first, second);
            this.face = face;
        }

        private void setupTransform(MatrixStacker msr, float progress) {
            float dialPivot = 0.359375f;
            GaugeInstance.this.ms.func_227860_a_();
            this.rotateToFace(msr);
            ((ModelData)this.getSecond()).setTransform(GaugeInstance.this.ms);
            msr.translate(0.0, dialPivot, dialPivot).rotate(Direction.EAST, (float)(1.5707963267948966 * (double)(-progress))).translate(0.0, -dialPivot, -dialPivot);
            ((ModelData)this.getFirst()).setTransform(GaugeInstance.this.ms);
            GaugeInstance.this.ms.func_227865_b_();
        }

        private void updateTransform(MatrixStacker msr, float progress) {
            float dialPivot = 0.359375f;
            GaugeInstance.this.ms.func_227860_a_();
            this.rotateToFace(msr).translate(0.0, dialPivot, dialPivot).rotate(Direction.EAST, (float)(1.5707963267948966 * (double)(-progress))).translate(0.0, -dialPivot, -dialPivot);
            ((ModelData)this.getFirst()).setTransform(GaugeInstance.this.ms);
            GaugeInstance.this.ms.func_227865_b_();
        }

        protected MatrixStacker rotateToFace(MatrixStacker msr) {
            return msr.centre().rotate(Direction.UP, (float)((double)((-this.face.func_185119_l() - 90.0f) / 180.0f) * Math.PI)).unCentre();
        }

        private void delete() {
            ((ModelData)this.getFirst()).delete();
            ((ModelData)this.getSecond()).delete();
        }
    }
}

