/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gauge;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeTileEntity;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class StressGaugeTileEntity
extends GaugeTileEntity {
    public StressGaugeTileEntity(TileEntityType<? extends StressGaugeTileEntity> type) {
        super(type);
    }

    @Override
    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.dialTarget = !IRotate.StressImpact.isEnabled() ? 0.0f : (this.isOverStressed() ? 1.125f : (maxStress == 0.0f ? 0.0f : currentStress / maxStress));
        if (this.dialTarget > 0.0f) {
            this.color = this.dialTarget < 0.5f ? ColorHelper.mixColors(65280, 0xFFFF00, this.dialTarget * 2.0f) : (this.dialTarget < 1.0f ? ColorHelper.mixColors(0xFFFF00, 0xFF0000, this.dialTarget * 2.0f - 1.0f) : 0xFF0000);
        }
        this.sendData();
        this.func_70296_d();
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() == 0.0f) {
            this.dialTarget = 0.0f;
            this.func_70296_d();
            return;
        }
        this.updateFromNetwork(this.capacity, this.stress, this.getOrCreateNetwork().getSize());
    }

    @Override
    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        double capacity = this.getNetworkCapacity();
        double stressFraction = (double)this.getNetworkStress() / (capacity == 0.0 ? 1.0 : capacity);
        tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("gui.stressometer.title", new Object[0]).func_240699_a_(TextFormatting.GRAY)));
        if (this.getTheoreticalSpeed() == 0.0f) {
            tooltip.add((ITextComponent)new StringTextComponent("    " + ItemDescription.makeProgressBar(3, -1)).func_230529_a_((ITextComponent)Lang.translate("gui.stressometer.no_rotation", new Object[0])).func_240699_a_(TextFormatting.DARK_GRAY));
        } else {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_(IRotate.StressImpact.getFormattedStressText(stressFraction)));
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("gui.stressometer.capacity", new Object[0]).func_240699_a_(TextFormatting.GRAY)));
            double remainingCapacity = capacity - (double)this.getNetworkStress();
            TranslationTextComponent su = Lang.translate("generic.unit.stress", new Object[0]);
            IFormattableTextComponent stressTooltip = componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)new StringTextComponent(" " + IHaveGoggleInformation.format(remainingCapacity)).func_230529_a_((ITextComponent)su.func_230531_f_()).func_240699_a_(IRotate.StressImpact.of(stressFraction).getRelativeColor()));
            if (remainingCapacity != capacity) {
                stressTooltip.func_230529_a_((ITextComponent)new StringTextComponent(" / ").func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)new StringTextComponent(IHaveGoggleInformation.format(capacity)).func_230529_a_((ITextComponent)su.func_230531_f_()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
            tooltip.add((ITextComponent)stressTooltip);
        }
        return true;
    }

    public float getNetworkStress() {
        return this.stress;
    }

    public float getNetworkCapacity() {
        return this.capacity;
    }
}

