/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.wrench;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class WrenchItem
extends Item {
    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null || !player.func_175142_cm()) {
            return super.func_195939_a(context);
        }
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        Block block = state.func_177230_c();
        if (!(block instanceof IWrenchable)) {
            if (this.canWrenchPickup(state)) {
                return this.onItemUseOnOther(context);
            }
            return super.func_195939_a(context);
        }
        IWrenchable actor = (IWrenchable)block;
        if (player.func_225608_bj_()) {
            return actor.onSneakWrenched(state, context);
        }
        return actor.onWrenched(state, context);
    }

    private boolean canWrenchPickup(BlockState state) {
        return AllTags.AllBlockTags.WRENCH_PICKUP.matches(state);
    }

    private ActionResultType onItemUseOnOther(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        if (!(world instanceof ServerWorld)) {
            return ActionResultType.SUCCESS;
        }
        if (player != null && !player.func_184812_l_()) {
            Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)player, (ItemStack)context.func_195996_i()).forEach(itemStack -> player.field_71071_by.func_191975_a(world, itemStack));
        }
        state.func_215706_a((ServerWorld)world, pos, ItemStack.field_190927_a);
        world.func_175655_b(pos, false);
        AllSoundEvents.WRENCH_REMOVE.playOnServer(world, pos, 1.0f, Create.RANDOM.nextFloat() * 0.5f + 0.5f);
        return ActionResultType.SUCCESS;
    }

    public static void wrenchInstaKillsMinecarts(AttackEntityEvent event) {
        Entity target = event.getTarget();
        if (!(target instanceof AbstractMinecartEntity)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (!AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        if (player.func_184812_l_()) {
            return;
        }
        AbstractMinecartEntity minecart = (AbstractMinecartEntity)target;
        minecart.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 100.0f);
    }
}

