/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities;

import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CRecipes;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class ChromaticCompoundItem
extends Item {
    public ChromaticCompoundItem(Item.Properties properties) {
        super(properties);
    }

    public boolean func_77651_p() {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int light = stack.func_196082_o().func_74762_e("CollectingLight");
        return 1.0f - (float)light / (float)((Integer)AllConfigs.SERVER.recipes.lightSourceCountForRefinedRadiance.get()).intValue();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int light = stack.func_196082_o().func_74762_e("CollectingLight");
        return light > 0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ColorHelper.mixColors(4275305, 0xFFFFFF, (float)(1.0 - this.getDurabilityForDisplay(stack)));
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.showDurabilityBar(stack) ? 1 : 16;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        ItemStack newStack;
        double y = entity.func_226278_cu_();
        double yMotion = entity.func_213322_ci().field_72448_b;
        World world = entity.field_70170_p;
        CompoundNBT data = entity.getPersistentData();
        CompoundNBT itemData = entity.func_92059_d().func_196082_o();
        Vector3d positionVec = entity.func_213303_ch();
        CRecipes config = AllConfigs.SERVER.recipes;
        if (world.field_72995_K) {
            int light = itemData.func_74762_e("CollectingLight");
            if (field_77697_d.nextInt((Integer)config.lightSourceCountForRefinedRadiance.get() + 20) < light) {
                Vector3d start = VecHelper.offsetRandomly(positionVec, field_77697_d, 3.0f);
                Vector3d motion = positionVec.func_178788_d(start).func_72432_b().func_186678_a((double)0.2f);
                world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, start.field_72450_a, start.field_72448_b, start.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
            }
            return false;
        }
        if (y < 0.0 && y - yMotion < -10.0 && ((Boolean)config.enableShadowSteelRecipe.get()).booleanValue()) {
            newStack = AllItems.SHADOW_STEEL.asStack();
            newStack.func_190920_e(stack.func_190916_E());
            data.func_74757_a("JustCreated", true);
            entity.func_92058_a(newStack);
        }
        if (!((Boolean)config.enableRefinedRadianceRecipe.get()).booleanValue()) {
            return false;
        }
        if (itemData.func_74762_e("CollectingLight") >= (Integer)config.lightSourceCountForRefinedRadiance.get()) {
            newStack = AllItems.REFINED_RADIANCE.asStack();
            ItemEntity newEntity = new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), newStack);
            newEntity.func_213317_d(entity.func_213322_ci());
            newEntity.getPersistentData().func_74757_a("JustCreated", true);
            itemData.func_82580_o("CollectingLight");
            world.func_217376_c((Entity)newEntity);
            stack.func_77979_a(1);
            entity.func_92058_a(stack);
            if (stack.func_190926_b()) {
                entity.func_70106_y();
            }
            return false;
        }
        boolean isOverBeacon = false;
        int entityX = MathHelper.func_76128_c((double)entity.func_226277_ct_());
        int entityZ = MathHelper.func_76128_c((double)entity.func_226281_cx_());
        int localWorldHeight = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, entityX, entityZ);
        BlockPos.Mutable testPos = new BlockPos.Mutable(entityX, Math.min(MathHelper.func_76128_c((double)entity.func_226278_cu_()), localWorldHeight), entityZ);
        while (testPos.func_177956_o() > 0) {
            BeaconTileEntity bte;
            testPos.func_189536_c(Direction.DOWN);
            BlockState state = world.func_180495_p((BlockPos)testPos);
            if (state.func_200016_a((IBlockReader)world, (BlockPos)testPos) >= 15 && state.func_177230_c() != Blocks.field_150357_h) break;
            if (state.func_177230_c() != Blocks.field_150461_bJ) continue;
            TileEntity te = world.func_175625_s((BlockPos)testPos);
            if (!(te instanceof BeaconTileEntity) || (bte = (BeaconTileEntity)te).func_191979_s() == 0 || bte.field_174909_f.isEmpty()) break;
            isOverBeacon = true;
            break;
        }
        if (isOverBeacon) {
            ItemStack newStack2 = AllItems.REFINED_RADIANCE.asStack();
            newStack2.func_190920_e(stack.func_190916_E());
            data.func_74757_a("JustCreated", true);
            entity.func_92058_a(newStack2);
            return false;
        }
        Random r = world.field_73012_v;
        int range = 3;
        float rate = 0.5f;
        if (r.nextFloat() > rate) {
            return false;
        }
        BlockPos randomOffset = new BlockPos(VecHelper.offsetRandomly(positionVec, r, range));
        BlockState state = world.func_180495_p(randomOffset);
        if (state.getLightValue((IBlockReader)world, randomOffset) == 0) {
            return false;
        }
        if (state.func_185887_b((IBlockReader)world, randomOffset) == -1.0f) {
            return false;
        }
        if (state.func_177230_c() == Blocks.field_150461_bJ) {
            return false;
        }
        RayTraceContext context = new RayTraceContext(positionVec, VecHelper.getCenterOf((Vector3i)randomOffset), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity);
        if (!randomOffset.equals((Object)world.func_217299_a(context).func_216350_a())) {
            return false;
        }
        world.func_175655_b(randomOffset, false);
        ItemStack newStack3 = stack.func_77979_a(1);
        newStack3.func_196082_o().func_74768_a("CollectingLight", itemData.func_74762_e("CollectingLight") + 1);
        ItemEntity newEntity = new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), newStack3);
        newEntity.func_213317_d(entity.func_213322_ci());
        newEntity.func_174869_p();
        world.func_217376_c((Entity)newEntity);
        entity.lifespan = 6000;
        if (stack.func_190926_b()) {
            entity.func_70106_y();
        }
        return false;
    }
}

