/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.bell;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.curiosities.bell.BasicParticleData;
import com.simibubi.create.content.curiosities.bell.CustomRotationParticle;
import com.simibubi.create.content.curiosities.bell.SoulPulseEffect;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class SoulParticle
extends CustomRotationParticle {
    private final IAnimatedSprite animatedSprite;
    protected int startTicks;
    protected int endTicks;
    protected int numLoops;
    protected int firstStartFrame = 0;
    protected int startFrames = 17;
    protected int firstLoopFrame = 17;
    protected int loopFrames = 16;
    protected int firstEndFrame = 33;
    protected int endFrames = 20;
    protected AnimationStage animationStage;
    protected int totalFrames = 53;
    protected int ticksPerFrame = 2;
    protected boolean isPerimeter = false;
    protected boolean isExpandingPerimeter = false;
    protected boolean isVisible = true;
    protected int perimeterFrames = 8;

    public SoulParticle(ClientWorld worldIn, double x, double y, double z, double vx, double vy, double vz, IAnimatedSprite spriteSet, IParticleData data) {
        super(worldIn, x, y, z, spriteSet, 0.0f);
        this.animatedSprite = spriteSet;
        this.field_70544_f = 0.5f;
        this.func_187115_a(this.field_70544_f, this.field_70544_f);
        this.loopLength = this.loopFrames + (int)(this.field_187136_p.nextFloat() * 5.0f - 4.0f);
        this.startTicks = this.startFrames + (int)(this.field_187136_p.nextFloat() * 5.0f - 4.0f);
        this.endTicks = this.endFrames + (int)(this.field_187136_p.nextFloat() * 5.0f - 4.0f);
        this.numLoops = (int)(1.0f + this.field_187136_p.nextFloat() * 2.0f);
        this.setFrame(0);
        this.field_228343_B_ = true;
        this.mirror = this.field_187136_p.nextBoolean();
        this.isPerimeter = data instanceof PerimeterData;
        this.isExpandingPerimeter = data instanceof ExpandingPerimeterData;
        AnimationStage animationStage = this.animationStage = !this.isPerimeter ? new StartAnimation(this) : new PerimeterAnimation(this);
        if (this.isPerimeter) {
            this.field_187124_d = this.field_187127_g -= 0.4921875;
            this.totalFrames = this.perimeterFrames;
            this.isVisible = false;
        }
    }

    public void func_189213_a() {
        this.animationStage.tick();
        this.animationStage = this.animationStage.getNext();
        BlockPos pos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        if (this.animationStage == null) {
            this.func_187112_i();
        }
        if (!SoulPulseEffect.isDark((World)this.field_187122_b, pos)) {
            this.isVisible = true;
            if (!this.isPerimeter) {
                this.func_187112_i();
            }
        } else if (this.isPerimeter) {
            this.isVisible = false;
        }
    }

    @Override
    public void func_225606_a_(IVertexBuilder builder, ActiveRenderInfo camera, float partialTicks) {
        if (!this.isVisible) {
            return;
        }
        super.func_225606_a_(builder, camera, partialTicks);
    }

    public void setFrame(int frame) {
        if (frame >= 0 && frame < this.totalFrames) {
            this.func_217567_a(this.animatedSprite.func_217591_a(frame, this.totalFrames));
        }
    }

    @Override
    public Quaternion getCustomRotation(ActiveRenderInfo camera, float partialTicks) {
        if (this.isPerimeter) {
            return Vector3f.field_229179_b_.func_229187_a_(90.0f);
        }
        return new Quaternion(0.0f, -camera.func_216778_f(), 0.0f, true);
    }

    public static class PerimeterAnimation
    extends AnimationStage {
        public PerimeterAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame((int)this.getAnimAge() % this.particle.perimeterFrames);
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < (this.particle.isExpandingPerimeter ? 8 : this.particle.startTicks + this.particle.endTicks + this.particle.numLoops * this.particle.loopLength)) {
                return this;
            }
            return null;
        }
    }

    public static class EndAnimation
    extends AnimationStage {
        public EndAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame(this.particle.firstEndFrame + (int)(this.getAnimAge() / (float)this.particle.endTicks * (float)this.particle.endFrames));
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < this.particle.endTicks) {
                return this;
            }
            return null;
        }
    }

    public static class LoopAnimation
    extends AnimationStage {
        int loops;

        public LoopAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            int loopTick = this.getLoopTick();
            if (loopTick == 0) {
                ++this.loops;
            }
            this.particle.setFrame(this.particle.firstLoopFrame + loopTick);
        }

        private int getLoopTick() {
            return this.animAge % this.particle.loopFrames;
        }

        @Override
        public AnimationStage getNext() {
            if (this.loops <= this.particle.numLoops) {
                return this;
            }
            return new EndAnimation(this.particle);
        }
    }

    public static class StartAnimation
    extends AnimationStage {
        public StartAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame(this.particle.firstStartFrame + (int)(this.getAnimAge() / (float)this.particle.startTicks * (float)this.particle.startFrames));
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < this.particle.startTicks) {
                return this;
            }
            return new LoopAnimation(this.particle);
        }
    }

    public static abstract class AnimationStage {
        protected final SoulParticle particle;
        protected int ticks;
        protected int animAge;

        public AnimationStage(SoulParticle particle) {
            this.particle = particle;
        }

        public void tick() {
            ++this.ticks;
            if (this.ticks % this.particle.ticksPerFrame == 0) {
                ++this.animAge;
            }
        }

        public float getAnimAge() {
            return this.animAge;
        }

        public abstract AnimationStage getNext();
    }

    public static class ExpandingPerimeterData
    extends PerimeterData {
        @Override
        public ParticleType<?> func_197554_b() {
            return AllParticleTypes.SOUL_EXPANDING_PERIMETER.get();
        }
    }

    public static class PerimeterData
    extends BasicParticleData<SoulParticle> {
        @Override
        public BasicParticleData.IBasicParticleFactory<SoulParticle> getBasicFactory() {
            return (worldIn, x, y, z, vx, vy, vz, spriteSet) -> new SoulParticle(worldIn, x, y, z, vx, vy, vz, spriteSet, this);
        }

        public ParticleType<?> func_197554_b() {
            return AllParticleTypes.SOUL_PERIMETER.get();
        }
    }

    public static class Data
    extends BasicParticleData<SoulParticle> {
        @Override
        public BasicParticleData.IBasicParticleFactory<SoulParticle> getBasicFactory() {
            return (worldIn, x, y, z, vx, vy, vz, spriteSet) -> new SoulParticle(worldIn, x, y, z, vx, vy, vz, spriteSet, this);
        }

        public ParticleType<?> func_197554_b() {
            return AllParticleTypes.SOUL.get();
        }
    }
}

