/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.curiosities.tools.BlueprintContainer;
import com.simibubi.create.content.curiosities.tools.BlueprintItem;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.schematics.ISpecialEntityItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.gui.IInteractionChecker;
import com.simibubi.create.foundation.networking.ISyncPersistentData;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.Validate;

public class BlueprintEntity
extends HangingEntity
implements IEntityAdditionalSpawnData,
ISpecialEntityItemRequirement,
ISyncPersistentData,
IInteractionChecker {
    protected int field_213325_aI;
    protected Direction verticalOrientation;
    private Map<Integer, BlueprintSection> sectionCache = new HashMap<Integer, BlueprintSection>();

    public BlueprintEntity(EntityType<?> p_i50221_1_, World p_i50221_2_) {
        super(p_i50221_1_, p_i50221_2_);
        this.field_213325_aI = 1;
    }

    public BlueprintEntity(World world, BlockPos pos, Direction facing, Direction verticalOrientation) {
        super((EntityType)AllEntityTypes.CRAFTING_BLUEPRINT.get(), world, pos);
        int size = 3;
        while (size > 0) {
            this.field_213325_aI = size--;
            this.updateFacingWithBoundingBox(facing, verticalOrientation);
            if (this.func_70518_d()) break;
        }
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74774_a("Facing", (byte)this.field_174860_b.func_176745_a());
        p_213281_1_.func_74774_a("Orientation", (byte)this.verticalOrientation.func_176745_a());
        p_213281_1_.func_74768_a("Size", this.field_213325_aI);
        super.func_213281_b(p_213281_1_);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        this.field_174860_b = Direction.func_82600_a((int)p_70037_1_.func_74771_c("Facing"));
        this.verticalOrientation = Direction.func_82600_a((int)p_70037_1_.func_74771_c("Orientation"));
        this.field_213325_aI = p_70037_1_.func_74762_e("Size");
        super.func_70037_a(p_70037_1_);
        this.updateFacingWithBoundingBox(this.field_174860_b, this.verticalOrientation);
    }

    protected void updateFacingWithBoundingBox(Direction facing, Direction verticalOrientation) {
        Validate.notNull((Object)facing);
        this.field_174860_b = facing;
        this.verticalOrientation = verticalOrientation;
        if (facing.func_176740_k().func_176722_c()) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = this.field_174860_b.func_176736_b() * 90;
        } else {
            this.field_70125_A = -90 * facing.func_176743_c().func_179524_a();
            this.field_70177_z = verticalOrientation.func_176740_k().func_176722_c() ? 180.0f + verticalOrientation.func_185119_l() : 0.0f;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.func_174856_o();
    }

    protected float func_213316_a(Pose p_213316_1_, EntitySize p_213316_2_) {
        return 0.0f;
    }

    protected void func_174856_o() {
        if (this.field_174860_b == null) {
            return;
        }
        if (this.verticalOrientation == null) {
            return;
        }
        Vector3d pos = Vector3d.func_237491_b_((Vector3i)this.field_174861_a).func_72441_c(0.5, 0.5, 0.5).func_178788_d(Vector3d.func_237491_b_((Vector3i)this.field_174860_b.func_176730_m()).func_186678_a(0.46875));
        double d1 = pos.field_72450_a;
        double d2 = pos.field_72448_b;
        double d3 = pos.field_72449_c;
        this.func_226288_n_(d1, d2, d3);
        Direction.Axis axis = this.field_174860_b.func_176740_k();
        if (this.field_213325_aI == 2) {
            pos = pos.func_178787_e(Vector3d.func_237491_b_((Vector3i)(axis.func_176722_c() ? this.field_174860_b.func_176735_f().func_176730_m() : this.verticalOrientation.func_176746_e().func_176730_m())).func_186678_a(0.5)).func_178787_e(Vector3d.func_237491_b_((Vector3i)(axis.func_176722_c() ? Direction.UP.func_176730_m() : (this.field_174860_b == Direction.UP ? this.verticalOrientation.func_176730_m() : this.verticalOrientation.func_176734_d().func_176730_m()))).func_186678_a(0.5));
        }
        d1 = pos.field_72450_a;
        d2 = pos.field_72448_b;
        d3 = pos.field_72449_c;
        double d4 = this.func_82329_d();
        double d5 = this.func_82330_g();
        double d6 = this.func_82329_d();
        Direction.Axis direction$axis = this.field_174860_b.func_176740_k();
        switch (direction$axis) {
            case X: {
                d4 = 1.0;
                break;
            }
            case Y: {
                d5 = 1.0;
                break;
            }
            case Z: {
                d6 = 1.0;
            }
        }
        this.func_174826_a(new AxisAlignedBB(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6));
    }

    public boolean func_70518_d() {
        if (!this.field_70170_p.func_226669_j_((Entity)this)) {
            return false;
        }
        int i = Math.max(1, this.func_82329_d() / 16);
        int j = Math.max(1, this.func_82330_g() / 16);
        BlockPos blockpos = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
        Direction upDirection = this.field_174860_b.func_176740_k().func_176722_c() ? Direction.UP : (this.field_174860_b == Direction.UP ? this.verticalOrientation : this.verticalOrientation.func_176734_d());
        Direction direction = this.field_174860_b.func_176740_k().func_200128_b() ? this.verticalOrientation.func_176746_e() : this.field_174860_b.func_176735_f();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                int i1 = (i - 1) / -2;
                int j1 = (j - 1) / -2;
                blockpos$mutable.func_189533_g((Vector3i)blockpos).func_189534_c(direction, k + i1).func_189534_c(upDirection, l + j1);
                BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
                if (Block.func_220055_a((IWorldReader)this.field_70170_p, (BlockPos)blockpos$mutable, (Direction)this.field_174860_b) || blockstate.func_185904_a().func_76220_a() || RedstoneDiodeBlock.func_185546_B((BlockState)blockstate)) continue;
                return false;
            }
        }
        return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), field_184524_c).isEmpty();
    }

    public int func_82329_d() {
        return 16 * this.field_213325_aI;
    }

    public int func_82330_g() {
        return 16 * this.field_213325_aI;
    }

    public boolean func_85031_j(Entity source) {
        if (!(source instanceof PlayerEntity) || this.field_70170_p.field_72995_K) {
            return super.func_85031_j(source);
        }
        PlayerEntity player = (PlayerEntity)source;
        double attrib = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + (double)(player.func_184812_l_() ? 0.0f : -0.5f);
        Vector3d eyePos = source.func_174824_e(1.0f);
        Vector3d look = source.func_70676_i(1.0f);
        Vector3d target = eyePos.func_178787_e(look.func_186678_a(attrib));
        Optional rayTrace = this.func_174813_aQ().func_216365_b(eyePos, target);
        if (!rayTrace.isPresent()) {
            return super.func_85031_j(source);
        }
        Vector3d hitVec = (Vector3d)rayTrace.get();
        BlueprintSection sectionAt = this.getSectionAt(hitVec.func_178788_d(this.func_213303_ch()));
        ItemStackHandler items = sectionAt.getItems();
        if (items.getStackInSlot(9).func_190926_b()) {
            return super.func_85031_j(source);
        }
        for (int i = 0; i < items.getSlots(); ++i) {
            items.setStackInSlot(i, ItemStack.field_190927_a);
        }
        sectionAt.save(items);
        return true;
    }

    public void func_110128_b(@Nullable Entity p_110128_1_) {
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            return;
        }
        this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
        if (p_110128_1_ instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)p_110128_1_;
            if (playerentity.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        this.func_199701_a_(AllItems.CRAFTING_BLUEPRINT.asStack());
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return AllItems.CRAFTING_BLUEPRINT.asStack();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, (Item)AllItems.CRAFTING_BLUEPRINT.get());
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
    }

    public void func_70012_b(double p_70012_1_, double p_70012_3_, double p_70012_5_, float p_70012_7_, float p_70012_8_) {
        this.func_70107_b(p_70012_1_, p_70012_3_, p_70012_5_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        BlockPos blockpos = this.field_174861_a.func_177963_a(p_180426_1_ - this.func_226277_ct_(), p_180426_3_ - this.func_226278_cu_(), p_180426_5_ - this.func_226281_cx_());
        this.func_70107_b(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        this.func_213281_b(compound);
        buffer.func_150786_a(compound);
        buffer.func_150786_a(this.getPersistentData());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.func_70037_a(additionalData.func_150793_b());
        this.getPersistentData().func_197643_a(additionalData.func_150793_b());
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (player instanceof FakePlayer) {
            return ActionResultType.PASS;
        }
        boolean holdingWrench = AllItems.WRENCH.isIn(player.func_184586_b(hand));
        BlueprintSection section = this.getSectionAt(vec);
        ItemStackHandler items = section.getItems();
        if (!(holdingWrench || this.field_70170_p.field_72995_K || items.getStackInSlot(9).func_190926_b())) {
            InvWrapper playerInv = new InvWrapper((IInventory)player.field_71071_by);
            boolean firstPass = true;
            int amountCrafted = 0;
            ForgeHooks.setCraftingPlayer((PlayerEntity)player);
            Optional recipe = Optional.empty();
            do {
                HashMap<Integer, ItemStack> stacksTaken = new HashMap<Integer, ItemStack>();
                HashMap<Integer, ItemStack> craftingGrid = new HashMap<Integer, ItemStack>();
                boolean success = true;
                block1: for (int i = 0; i < 9; ++i) {
                    ItemStack requestedItem = items.getStackInSlot(i);
                    if (requestedItem.func_190926_b()) {
                        craftingGrid.put(i, ItemStack.field_190927_a);
                        continue;
                    }
                    for (int slot = 0; slot < playerInv.getSlots(); ++slot) {
                        if (!FilterItem.test(this.field_70170_p, playerInv.getStackInSlot(slot), requestedItem)) continue;
                        ItemStack currentItem = playerInv.extractItem(slot, 1, false);
                        if (stacksTaken.containsKey(slot)) {
                            ((ItemStack)stacksTaken.get(slot)).func_190917_f(1);
                        } else {
                            stacksTaken.put(slot, currentItem.func_77946_l());
                        }
                        craftingGrid.put(i, currentItem);
                        continue block1;
                    }
                    success = false;
                    break;
                }
                if (success) {
                    ItemStack result;
                    BlueprintCraftingInventory craftingInventory = new BlueprintCraftingInventory(craftingGrid);
                    if (!recipe.isPresent()) {
                        recipe = this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInventory, this.field_70170_p);
                    }
                    if ((result = recipe.filter(r -> r.func_77569_a((IInventory)craftingInventory, this.field_70170_p)).map(r -> r.func_77572_b((IInventory)craftingInventory)).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                        success = false;
                    } else if (result.func_190916_E() + amountCrafted > 64) {
                        success = false;
                    } else {
                        amountCrafted += result.func_190916_E();
                        result.func_77980_a(player.field_70170_p, player, 1);
                        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)result, (IInventory)craftingInventory);
                        NonNullList nonnulllist = this.field_70170_p.func_199532_z().func_215369_c(IRecipeType.field_222149_a, (IInventory)craftingInventory, this.field_70170_p);
                        if (firstPass) {
                            this.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, 1.0f + Create.RANDOM.nextFloat());
                        }
                        player.field_71071_by.func_191975_a(this.field_70170_p, result);
                        for (ItemStack itemStack : nonnulllist) {
                            player.field_71071_by.func_191975_a(this.field_70170_p, itemStack);
                        }
                        firstPass = false;
                    }
                }
                if (success) continue;
                for (Map.Entry entry : stacksTaken.entrySet()) {
                    playerInv.insertItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue(), false);
                }
                break;
            } while (player.func_225608_bj_());
            ForgeHooks.setCraftingPlayer(null);
            return ActionResultType.SUCCESS;
        }
        int i = section.index;
        if (!this.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)section, buf -> {
                buf.func_150787_b(this.func_145782_y());
                buf.func_150787_b(i);
            });
        }
        return ActionResultType.SUCCESS;
    }

    public BlueprintSection getSectionAt(Vector3d vec) {
        int index = 0;
        if (this.field_213325_aI > 1) {
            vec = VecHelper.rotate(vec, this.field_70177_z, Direction.Axis.Y);
            vec = VecHelper.rotate(vec, -this.field_70125_A, Direction.Axis.X);
            vec = vec.func_72441_c(0.5, 0.5, 0.0);
            if (this.field_213325_aI == 3) {
                vec = vec.func_72441_c(1.0, 1.0, 0.0);
            }
            int x = MathHelper.func_76125_a((int)MathHelper.func_76128_c((double)vec.field_72450_a), (int)0, (int)(this.field_213325_aI - 1));
            int y = MathHelper.func_76125_a((int)MathHelper.func_76128_c((double)vec.field_72448_b), (int)0, (int)(this.field_213325_aI - 1));
            index = x + y * this.field_213325_aI;
        }
        BlueprintSection section = this.getSection(index);
        return section;
    }

    public CompoundNBT getOrCreateRecipeCompound() {
        CompoundNBT persistentData = this.getPersistentData();
        if (!persistentData.func_74764_b("Recipes")) {
            persistentData.func_218657_a("Recipes", (INBT)new CompoundNBT());
        }
        return persistentData.func_74775_l("Recipes");
    }

    public BlueprintSection getSection(int index) {
        return this.sectionCache.computeIfAbsent(index, i -> new BlueprintSection((int)i));
    }

    @Override
    public void onPersistentDataUpdated() {
        this.sectionCache.clear();
    }

    @Override
    public boolean canPlayerUse(PlayerEntity player) {
        AxisAlignedBB box = this.func_174813_aQ();
        double dx = 0.0;
        if (box.field_72340_a > player.func_226277_ct_()) {
            dx = box.field_72340_a - player.func_226277_ct_();
        } else if (player.func_226277_ct_() > box.field_72336_d) {
            dx = player.func_226277_ct_() - box.field_72336_d;
        }
        double dy = 0.0;
        if (box.field_72338_b > player.func_226278_cu_()) {
            dy = box.field_72338_b - player.func_226278_cu_();
        } else if (player.func_226278_cu_() > box.field_72337_e) {
            dy = player.func_226278_cu_() - box.field_72337_e;
        }
        double dz = 0.0;
        if (box.field_72339_c > player.func_226281_cx_()) {
            dz = box.field_72339_c - player.func_226281_cx_();
        } else if (player.func_226281_cx_() > box.field_72334_f) {
            dz = player.func_226281_cx_() - box.field_72334_f;
        }
        return dx * dx + dy * dy + dz * dz <= 64.0;
    }

    class BlueprintSection
    implements INamedContainerProvider,
    IInteractionChecker {
        int index;
        Couple<ItemStack> cachedDisplayItems;
        public boolean inferredIcon = false;

        public BlueprintSection(int index) {
            this.index = index;
        }

        public Couple<ItemStack> getDisplayItems() {
            if (this.cachedDisplayItems != null) {
                return this.cachedDisplayItems;
            }
            ItemStackHandler items = this.getItems();
            this.cachedDisplayItems = Couple.create(items.getStackInSlot(9), items.getStackInSlot(10));
            return this.cachedDisplayItems;
        }

        public ItemStackHandler getItems() {
            ItemStackHandler newInv = new ItemStackHandler(11);
            CompoundNBT list = BlueprintEntity.this.getOrCreateRecipeCompound();
            CompoundNBT invNBT = list.func_74775_l(this.index + "");
            this.inferredIcon = list.func_74767_n("InferredIcon");
            if (!invNBT.isEmpty()) {
                newInv.deserializeNBT(invNBT);
            }
            return newInv;
        }

        public void save(ItemStackHandler inventory) {
            CompoundNBT list = BlueprintEntity.this.getOrCreateRecipeCompound();
            list.func_218657_a(this.index + "", (INBT)inventory.serializeNBT());
            list.func_74757_a("InferredIcon", this.inferredIcon);
            this.cachedDisplayItems = null;
            if (!BlueprintEntity.this.field_70170_p.field_72995_K) {
                BlueprintEntity.this.syncPersistentDataWithTracking((Entity)BlueprintEntity.this);
            }
        }

        public boolean isEntityAlive() {
            return BlueprintEntity.this.func_70089_S();
        }

        public World getBlueprintWorld() {
            return BlueprintEntity.this.field_70170_p;
        }

        public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
            return BlueprintContainer.create(id, inv, this);
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent(((BlueprintItem)((Object)AllItems.CRAFTING_BLUEPRINT.get())).func_77658_a());
        }

        @Override
        public boolean canPlayerUse(PlayerEntity player) {
            return BlueprintEntity.this.canPlayerUse(player);
        }
    }

    static class BlueprintCraftingInventory
    extends CraftingInventory {
        private static Container dummyContainer = new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        };

        public BlueprintCraftingInventory(Map<Integer, ItemStack> items) {
            super(dummyContainer, 3, 3);
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    ItemStack stack = items.get(y * 3 + x);
                    this.func_70299_a(y * 3 + x, stack == null ? ItemStack.field_190927_a : stack.func_77946_l());
                }
            }
        }
    }
}

