/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.particle.AirParticleData;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonProjectileTypes;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileRenderMode;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class PotatoProjectileEntity
extends DamagingProjectileEntity
implements IEntityAdditionalSpawnData {
    PotatoCannonProjectileTypes field_200606_g;
    ItemStack stack = ItemStack.field_190927_a;
    Entity stuckEntity;
    Vector3d stuckOffset;
    PotatoProjectileRenderMode stuckRenderer;
    double stuckFallSpeed;
    float additionalDamageMult = 1.0f;
    float additionalKnockback = 0.0f;
    float recoveryChance = 0.0f;

    public PotatoProjectileEntity(EntityType<? extends DamagingProjectileEntity> type, World world) {
        super(type, world);
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public void setItem(ItemStack stack) {
        this.stack = stack;
    }

    public PotatoCannonProjectileTypes getProjectileType() {
        if (this.field_200606_g == null) {
            this.field_200606_g = PotatoCannonProjectileTypes.getProjectileTypeOf(this.stack).orElse(PotatoCannonProjectileTypes.FALLBACK);
        }
        return this.field_200606_g;
    }

    public void setEnchantmentEffectsFromCannon(ItemStack cannon) {
        int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)cannon);
        int punch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)cannon);
        int flame = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)cannon);
        int recovery = EnchantmentHelper.func_77506_a((Enchantment)AllEnchantments.POTATO_RECOVERY.get(), (ItemStack)cannon);
        if (power > 0) {
            this.additionalDamageMult = 1.0f + (float)power * 0.2f;
        }
        if (punch > 0) {
            this.additionalKnockback = (float)punch * 0.5f;
        }
        if (flame > 0) {
            this.func_70015_d(100);
        }
        if (recovery > 0) {
            this.recoveryChance = 0.125f + (float)recovery * 0.125f;
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        this.stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item"));
        this.additionalDamageMult = nbt.func_74760_g("AdditionalDamage");
        this.additionalKnockback = nbt.func_74760_g("AdditionalKnockback");
        this.recoveryChance = nbt.func_74760_g("Recovery");
        super.func_70037_a(nbt);
    }

    public void func_213281_b(CompoundNBT nbt) {
        nbt.func_218657_a("Item", (INBT)this.stack.serializeNBT());
        nbt.func_74776_a("AdditionalDamage", this.additionalDamageMult);
        nbt.func_74776_a("AdditionalKnockback", this.additionalKnockback);
        nbt.func_74776_a("Recovery", this.recoveryChance);
        super.func_213281_b(nbt);
    }

    public Entity getStuckEntity() {
        if (this.stuckEntity == null) {
            return null;
        }
        if (!this.stuckEntity.func_70089_S()) {
            return null;
        }
        return this.stuckEntity;
    }

    public void setStuckEntity(Entity stuckEntity) {
        this.stuckEntity = stuckEntity;
        this.stuckOffset = this.func_213303_ch().func_178788_d(stuckEntity.func_213303_ch());
        this.stuckRenderer = new PotatoProjectileRenderMode.StuckToEntity(this.stuckOffset);
        this.stuckFallSpeed = 0.0;
        this.func_213317_d(Vector3d.field_186680_a);
    }

    public PotatoProjectileRenderMode getRenderMode() {
        if (this.getStuckEntity() != null) {
            return this.stuckRenderer;
        }
        return this.getProjectileType().getRenderMode();
    }

    public void func_70071_h_() {
        PotatoCannonProjectileTypes projectileType = this.getProjectileType();
        Entity stuckEntity = this.getStuckEntity();
        if (stuckEntity != null) {
            if (this.func_226278_cu_() < stuckEntity.func_226278_cu_() - 0.1) {
                this.pop(this.func_213303_ch());
                this.func_70106_y();
            } else {
                this.stuckFallSpeed += 0.007 * (double)projectileType.getGravityMultiplier();
                this.stuckOffset = this.stuckOffset.func_72441_c(0.0, -this.stuckFallSpeed, 0.0);
                Vector3d pos = stuckEntity.func_213303_ch().func_178787_e(this.stuckOffset);
                this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            }
        } else {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.05 * (double)projectileType.getGravityMultiplier(), 0.0).func_186678_a((double)projectileType.getDrag()));
        }
        super.func_70071_h_();
    }

    protected float func_82341_c() {
        return 1.0f;
    }

    protected IParticleData func_195057_f() {
        return new AirParticleData(1.0f, 10.0f);
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected void func_213868_a(EntityRayTraceResult ray) {
        Vector3d appliedMotion;
        boolean onServer;
        super.func_213868_a(ray);
        if (this.getStuckEntity() != null) {
            return;
        }
        Vector3d hit = ray.func_216347_e();
        Entity target = ray.func_216348_a();
        PotatoCannonProjectileTypes projectileType = this.getProjectileType();
        float damage = MathHelper.func_76141_d((float)((float)projectileType.getDamage() * this.additionalDamageMult));
        float knockback = projectileType.getKnockback() + this.additionalKnockback;
        Entity owner = this.func_234616_v_();
        if (!target.func_70089_S()) {
            return;
        }
        if (owner instanceof LivingEntity) {
            ((LivingEntity)owner).func_130011_c(target);
        }
        if (target instanceof PotatoProjectileEntity && this.field_70173_aa < 10 && target.field_70173_aa < 10) {
            return;
        }
        this.pop(hit);
        if (target instanceof WitherEntity && ((WitherEntity)target).func_225509_J__()) {
            return;
        }
        boolean targetIsEnderman = target.func_200600_R() == EntityType.field_200803_q;
        int k = target.func_223314_ad();
        if (this.func_70027_ad() && !targetIsEnderman) {
            target.func_70015_d(5);
        }
        boolean bl = onServer = !this.field_70170_p.field_72995_K;
        if (onServer && !target.func_70097_a(this.causePotatoDamage(), damage)) {
            target.func_241209_g_(k);
            this.func_70106_y();
            return;
        }
        if (targetIsEnderman) {
            return;
        }
        if (!projectileType.onEntityHit(ray) && onServer && this.field_70146_Z.nextDouble() <= (double)this.recoveryChance) {
            this.recoverItem();
        }
        if (!(target instanceof LivingEntity)) {
            PotatoProjectileEntity.playHitSound(this.field_70170_p, this.func_213303_ch());
            this.func_70106_y();
            return;
        }
        LivingEntity livingentity = (LivingEntity)target;
        if (this.field_200606_g.getReloadTicks() < 10) {
            livingentity.field_70172_ad = this.field_200606_g.getReloadTicks() + 10;
        }
        if (knockback > 0.0f && (appliedMotion = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)knockback * 0.6)).func_189985_c() > 0.0) {
            livingentity.func_70024_g(appliedMotion.field_72450_a, 0.1, appliedMotion.field_72449_c);
        }
        if (onServer && owner instanceof LivingEntity) {
            EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)owner);
            EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)owner), (Entity)livingentity);
        }
        if (livingentity != owner && livingentity instanceof PlayerEntity && owner instanceof ServerPlayerEntity && !this.func_174814_R()) {
            ((ServerPlayerEntity)owner).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
        }
        if (onServer && owner instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)owner;
            if (!target.func_70089_S() && target.func_200600_R().func_220339_d() == EntityClassification.MONSTER || target instanceof PlayerEntity && target != owner) {
                AllTriggers.POTATO_KILL.trigger(serverplayerentity);
            }
        }
        if (this.field_200606_g.isSticky() && target.func_70089_S()) {
            this.setStuckEntity(target);
        } else {
            this.func_70106_y();
        }
    }

    private void recoverItem() {
        if (!this.stack.func_190926_b()) {
            this.func_199701_a_(ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)1));
        }
    }

    public static void playHitSound(World world, Vector3d location) {
        AllSoundEvents.POTATO_HIT.playOnServer(world, new BlockPos(location));
    }

    public static void playLaunchSound(World world, Vector3d location, float pitch) {
        AllSoundEvents.FWOOMP.playAt(world, location, 1.0f, pitch, true);
    }

    protected void func_230299_a_(BlockRayTraceResult ray) {
        Vector3d hit = ray.func_216347_e();
        this.pop(hit);
        if (!this.getProjectileType().onBlockHit((IWorld)this.field_70170_p, ray) && !this.field_70170_p.field_72995_K && this.field_70146_Z.nextDouble() <= (double)this.recoveryChance) {
            this.recoverItem();
        }
        super.func_230299_a_(ray);
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float amt) {
        if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        this.pop(this.func_213303_ch());
        this.func_70106_y();
        return true;
    }

    private void pop(Vector3d hit) {
        if (!this.stack.func_190926_b()) {
            for (int i = 0; i < 7; ++i) {
                Vector3d m = VecHelper.offsetRandomly(Vector3d.field_186680_a, this.field_70146_Z, 0.25f);
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.stack), hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            PotatoProjectileEntity.playHitSound(this.field_70170_p, this.func_213303_ch());
        }
    }

    private DamageSource causePotatoDamage() {
        return new PotatoDamageSource((Entity)this, this.func_234616_v_()).func_76349_b();
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.func_220321_a(0.25f, 0.25f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        this.func_213281_b(compound);
        buffer.func_150786_a(compound);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.func_70037_a(additionalData.func_150793_b());
    }

    public static class PotatoDamageSource
    extends IndirectEntityDamageSource {
        public PotatoDamageSource(Entity source, @Nullable Entity trueSource) {
            super("create.potato_cannon", source, trueSource);
        }
    }
}

