/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.simibubi.create.content.curiosities.zapper.ShootableGadgetRenderHandler;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class ShootGadgetPacket
extends SimplePacketBase {
    public Vector3d location;
    public Hand hand;
    public boolean self;

    public ShootGadgetPacket(Vector3d location, Hand hand, boolean self) {
        this.location = location;
        this.hand = hand;
        this.self = self;
    }

    public ShootGadgetPacket(PacketBuffer buffer) {
        this.hand = buffer.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
        this.self = buffer.readBoolean();
        this.location = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.readAdditional(buffer);
    }

    @Override
    public final void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.hand == Hand.MAIN_HAND);
        buffer.writeBoolean(this.self);
        buffer.writeDouble(this.location.field_72450_a);
        buffer.writeDouble(this.location.field_72448_b);
        buffer.writeDouble(this.location.field_72449_c);
        this.writeAdditional(buffer);
    }

    protected abstract void readAdditional(PacketBuffer var1);

    protected abstract void writeAdditional(PacketBuffer var1);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void handleAdditional();

    @OnlyIn(value=Dist.CLIENT)
    protected abstract ShootableGadgetRenderHandler getHandler();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public final void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
            if (renderViewEntity == null) {
                return;
            }
            if (renderViewEntity.func_213303_ch().func_72438_d(this.location) > 100.0) {
                return;
            }
            ShootableGadgetRenderHandler handler = this.getHandler();
            this.handleAdditional();
            if (this.self) {
                handler.shoot(this.hand, this.location);
            } else {
                handler.playSound(this.hand, this.location);
            }
        });
        context.get().setPacketHandled(true);
    }
}

