/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block;

import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class FlapData
extends InstanceData
implements IFlatLight<FlapData> {
    private float x;
    private float y;
    private float z;
    private byte blockLight;
    private byte skyLight;
    private float segmentOffsetX;
    private float segmentOffsetY;
    private float segmentOffsetZ;
    private float pivotX;
    private float pivotY;
    private float pivotZ;
    private float horizontalAngle;
    private float intensity;
    private float flapScale;
    private float flapness;

    public FlapData(Instancer<?> owner) {
        super(owner);
    }

    public FlapData setPosition(BlockPos pos) {
        return this.setPosition(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public FlapData setPosition(Vector3f pos) {
        return this.setPosition(pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c());
    }

    public FlapData setPosition(int x, int y, int z) {
        Vector3i origin = (Vector3i)this.owner.originCoordinate.get();
        return this.setPosition((float)(x - origin.func_177958_n()), (float)(y - origin.func_177956_o()), (float)(z - origin.func_177952_p()));
    }

    public FlapData setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.markDirty();
        return this;
    }

    public FlapData setBlockLight(int blockLight) {
        this.blockLight = (byte)((blockLight & 0xF) << 4);
        this.markDirty();
        return this;
    }

    public FlapData setSkyLight(int skyLight) {
        this.skyLight = (byte)((skyLight & 0xF) << 4);
        this.markDirty();
        return this;
    }

    public FlapData setSegmentOffset(float x, float y, float z) {
        this.segmentOffsetX = x;
        this.segmentOffsetY = y;
        this.segmentOffsetZ = z;
        this.markDirty();
        return this;
    }

    public FlapData setIntensity(float intensity) {
        this.intensity = intensity;
        this.markDirty();
        return this;
    }

    public FlapData setHorizontalAngle(float horizontalAngle) {
        this.horizontalAngle = horizontalAngle;
        this.markDirty();
        return this;
    }

    public FlapData setFlapScale(float flapScale) {
        this.flapScale = flapScale;
        this.markDirty();
        return this;
    }

    public FlapData setFlapness(float flapness) {
        this.flapness = flapness;
        this.markDirty();
        return this;
    }

    public FlapData setPivotVoxelSpace(float x, float y, float z) {
        this.pivotX = x / 16.0f;
        this.pivotY = y / 16.0f;
        this.pivotZ = z / 16.0f;
        this.markDirty();
        return this;
    }

    public void write(MappedBuffer buf) {
        buf.putVec3(this.x, this.y, this.z);
        buf.putVec2(this.blockLight, this.skyLight);
        buf.putVec3(this.segmentOffsetX, this.segmentOffsetY, this.segmentOffsetZ);
        buf.putVec3(this.pivotX, this.pivotY, this.pivotZ);
        buf.putFloat(this.horizontalAngle);
        buf.putFloat(this.intensity);
        buf.putFloat(this.flapScale);
        buf.putFloat(this.flapness);
    }
}

