/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.belts.tunnel;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.tile.TileEntityInstance;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.FlapData;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import com.simibubi.create.foundation.gui.widgets.InterpolatedValue;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.LightType;

public class BeltTunnelInstance
extends TileEntityInstance<BeltTunnelTileEntity>
implements IDynamicInstance {
    private final Map<Direction, ArrayList<FlapData>> tunnelFlaps = new EnumMap<Direction, ArrayList<FlapData>>(Direction.class);

    public BeltTunnelInstance(MaterialManager<?> modelManager, BeltTunnelTileEntity tile) {
        super(modelManager, (TileEntity)tile);
        Instancer model = modelManager.getMaterial(AllMaterialSpecs.FLAPS).getModel(AllBlockPartials.BELT_TUNNEL_FLAP, this.blockState);
        int blockLight = this.world.func_226658_a_(LightType.BLOCK, this.pos);
        int skyLight = this.world.func_226658_a_(LightType.SKY, this.pos);
        tile.flaps.forEach((direction, flapValue) -> {
            float flapness = flapValue.get(AnimationTickHolder.getPartialTicks());
            float horizontalAngle = direction.func_176734_d().func_185119_l();
            float flapScale = direction.func_176740_k() == Direction.Axis.X ? 1.0f : -1.0f;
            ArrayList<FlapData> flaps = new ArrayList<FlapData>(4);
            for (int segment = 0; segment <= 3; ++segment) {
                float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
                float segmentOffset = -0.1875f * (float)segment;
                FlapData key = (FlapData)model.createInstance();
                key.setPosition(this.pos).setSegmentOffset(segmentOffset, 0.0f, 0.0f).setBlockLight(blockLight).setSkyLight(skyLight).setHorizontalAngle(horizontalAngle).setFlapness(flapness).setFlapScale(flapScale).setPivotVoxelSpace(0.0f, 10.0f, 1.0f).setIntensity(intensity);
                flaps.add(key);
            }
            this.tunnelFlaps.put((Direction)direction, flaps);
        });
    }

    public boolean shouldReset() {
        return super.shouldReset() || this.tunnelFlaps.size() != ((BeltTunnelTileEntity)this.tile).flaps.size();
    }

    public void beginFrame() {
        this.tunnelFlaps.forEach((direction, keys) -> {
            InterpolatedValue flapValue = ((BeltTunnelTileEntity)this.tile).flaps.get(direction);
            if (flapValue == null) {
                return;
            }
            float flapness = flapValue.get(AnimationTickHolder.getPartialTicks());
            for (FlapData flap : keys) {
                flap.setFlapness(flapness);
            }
        });
    }

    public void updateLight() {
        this.relight(this.pos, this.tunnelFlaps.values().stream().flatMap(Collection::stream));
    }

    public void remove() {
        this.tunnelFlaps.values().stream().flatMap(Collection::stream).forEach(InstanceData::delete);
    }
}

