/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.logistics.block.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.block.depot.DepotRenderer;
import com.simibubi.create.content.logistics.block.depot.EjectorBlock;
import com.simibubi.create.content.logistics.block.depot.EjectorTileEntity;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class EjectorRenderer
extends KineticTileEntityRenderer {
    static final Vector3d pivot = VecHelper.voxelSpace(0.0, 11.25, 0.75);

    public EjectorRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean isGlobalRenderer(KineticTileEntity p_188185_1_) {
        return true;
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        EjectorTileEntity ejector = (EjectorTileEntity)te;
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228639_c_());
        float lidProgress = ((EjectorTileEntity)te).getLidProgress(partialTicks);
        float angle = lidProgress * 70.0f;
        if (!Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            SuperByteBuffer model = PartialBufferer.get(AllBlockPartials.EJECTOR_TOP, te.func_195044_w());
            EjectorRenderer.applyLidAngle(te, angle, model.matrixStacker());
            model.light(light).renderInto(ms, vertexBuilder);
        }
        MatrixStacker msr = MatrixStacker.of(ms);
        float maxTime = (float)(ejector.earlyTarget != null ? (double)ejector.earlyTargetTime : ejector.launcher.getTotalFlyingTicks());
        for (IntAttached<ItemStack> intAttached : ejector.launchedItems) {
            float time = (float)((Integer)intAttached.getFirst()).intValue() + partialTicks;
            if (time > maxTime) continue;
            ms.func_227860_a_();
            Vector3d launchedItemLocation = ejector.getLaunchedItemLocation(time);
            msr.translate(launchedItemLocation.func_178788_d(Vector3d.func_237491_b_((Vector3i)te.func_174877_v())));
            Vector3d itemRotOffset = VecHelper.voxelSpace(0.0, 3.0, 0.0);
            msr.translate(itemRotOffset);
            msr.rotateY(AngleHelper.horizontalAngle(ejector.getFacing()));
            msr.rotateX(time * 40.0f);
            msr.translateBack(itemRotOffset);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(intAttached.getValue(), ItemCameraTransforms.TransformType.GROUND, light, overlay, ms, buffer);
            ms.func_227865_b_();
        }
        DepotBehaviour behaviour = te.getBehaviour(DepotBehaviour.TYPE);
        if (behaviour == null || behaviour.isEmpty()) {
            return;
        }
        ms.func_227860_a_();
        EjectorRenderer.applyLidAngle(te, angle, msr);
        msr.centre().rotateY(-180.0f - AngleHelper.horizontalAngle((Direction)te.func_195044_w().func_177229_b(EjectorBlock.HORIZONTAL_FACING))).unCentre();
        DepotRenderer.renderItemsOf(te, partialTicks, ms, buffer, light, overlay, behaviour);
        ms.func_227865_b_();
    }

    static void applyLidAngle(KineticTileEntity te, float angle, MatrixStacker matrixStacker) {
        EjectorRenderer.applyLidAngle(te, pivot, angle, matrixStacker);
    }

    static void applyLidAngle(KineticTileEntity te, Vector3d rotationOffset, float angle, MatrixStacker matrixStacker) {
        matrixStacker.centre().rotateY(180.0f + AngleHelper.horizontalAngle((Direction)te.func_195044_w().func_177229_b(EjectorBlock.HORIZONTAL_FACING))).unCentre().translate(rotationOffset).rotateX(-angle).translateBack(rotationOffset);
    }

    @Override
    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return EjectorRenderer.shaft(EjectorRenderer.getRotationAxisOf(te));
    }
}

