/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.block.depot.EjectorPlacementPacket;
import com.simibubi.create.content.logistics.block.depot.EjectorTileEntity;
import com.simibubi.create.content.logistics.block.depot.EntityLauncher;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class EjectorTargetHandler {
    static BlockPos currentSelection;
    static ItemStack currentItem;
    static long lastHoveredBlockPos;
    static EntityLauncher launcher;

    @SubscribeEvent
    public static void rightClickingBlocksSelectsThem(PlayerInteractEvent.RightClickBlock event) {
        if (currentItem == null) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        if (!world.field_72995_K) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player == null || player.func_175149_v() || !player.func_225608_bj_()) {
            return;
        }
        String key = "weighted_ejector.target_set";
        TextFormatting colour = TextFormatting.GOLD;
        player.func_146105_b((ITextComponent)Lang.translate(key, new Object[0]).func_240699_a_(colour), true);
        currentSelection = pos;
        launcher = null;
        event.setCanceled(true);
        event.setCancellationResult(ActionResultType.SUCCESS);
    }

    @SubscribeEvent
    public static void leftClickingBlocksDeselectsThem(PlayerInteractEvent.LeftClickBlock event) {
        if (currentItem == null) {
            return;
        }
        if (!event.getWorld().field_72995_K) {
            return;
        }
        if (!event.getPlayer().func_225608_bj_()) {
            return;
        }
        BlockPos pos = event.getPos();
        if (pos.equals((Object)currentSelection)) {
            currentSelection = null;
            launcher = null;
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    public static void flushSettings(BlockPos pos) {
        Direction validTargetDirection;
        if (currentItem == null) {
            return;
        }
        int h = 0;
        int v = 0;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        String key = "weighted_ejector.target_not_valid";
        TextFormatting colour = TextFormatting.WHITE;
        if (currentSelection == null) {
            key = "weighted_ejector.no_target";
        }
        if ((validTargetDirection = EjectorTargetHandler.getValidTargetDirection(pos)) == null) {
            player.func_146105_b((ITextComponent)Lang.translate(key, new Object[0]).func_240699_a_(colour), true);
            currentItem = null;
            currentSelection = null;
            return;
        }
        key = "weighted_ejector.targeting";
        colour = TextFormatting.GREEN;
        player.func_146105_b((ITextComponent)Lang.translate(key, currentSelection.func_177958_n(), currentSelection.func_177956_o(), currentSelection.func_177952_p()).func_240699_a_(colour), true);
        BlockPos diff = pos.func_177973_b((Vector3i)currentSelection);
        h = Math.abs(diff.func_177958_n() + diff.func_177952_p());
        v = -diff.func_177956_o();
        AllPackets.channel.sendToServer((Object)new EjectorPlacementPacket(h, v, pos, validTargetDirection));
        currentSelection = null;
        currentItem = null;
    }

    public static Direction getValidTargetDirection(BlockPos pos) {
        if (currentSelection == null) {
            return null;
        }
        if (VecHelper.onSameAxis(pos, currentSelection, Direction.Axis.Y)) {
            return null;
        }
        int xDiff = currentSelection.func_177958_n() - pos.func_177958_n();
        int zDiff = currentSelection.func_177952_p() - pos.func_177952_p();
        int max = (Integer)AllConfigs.SERVER.kinetics.maxEjectorDistance.get();
        if (Math.abs(xDiff) > max || Math.abs(zDiff) > max) {
            return null;
        }
        if (xDiff == 0) {
            return Direction.func_181076_a((Direction.AxisDirection)(zDiff < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)Direction.Axis.Z);
        }
        if (zDiff == 0) {
            return Direction.func_181076_a((Direction.AxisDirection)(xDiff < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)Direction.Axis.X);
        }
        return null;
    }

    public static void tick() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack heldItemMainhand = player.func_184614_ca();
        if (!AllBlocks.WEIGHTED_EJECTOR.isIn(heldItemMainhand)) {
            currentItem = null;
        } else {
            if (heldItemMainhand != currentItem) {
                currentSelection = null;
                currentItem = heldItemMainhand;
            }
            EjectorTargetHandler.drawOutline(currentSelection);
        }
        EjectorTargetHandler.checkForWrench(heldItemMainhand);
        EjectorTargetHandler.drawArc();
    }

    protected static void drawArc() {
        int validZ;
        Minecraft mc = Minecraft.func_71410_x();
        boolean wrench = AllItems.WRENCH.isIn(mc.field_71439_g.func_184614_ca());
        if (currentSelection == null) {
            return;
        }
        if (currentItem == null && !wrench) {
            return;
        }
        RayTraceResult objectMouseOver = mc.field_71476_x;
        if (!(objectMouseOver instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)objectMouseOver;
        if (blockRayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        BlockPos pos = blockRayTraceResult.func_216350_a();
        if (!wrench) {
            pos = pos.func_177972_a(blockRayTraceResult.func_216354_b());
        }
        int xDiff = currentSelection.func_177958_n() - pos.func_177958_n();
        int yDiff = currentSelection.func_177956_o() - pos.func_177956_o();
        int zDiff = currentSelection.func_177952_p() - pos.func_177952_p();
        int validX = Math.abs(zDiff) > Math.abs(xDiff) ? 0 : xDiff;
        BlockPos validPos = currentSelection.func_177982_a(validX, yDiff, validZ = Math.abs(zDiff) < Math.abs(xDiff) ? 0 : zDiff);
        Direction d = EjectorTargetHandler.getValidTargetDirection(validPos);
        if (d == null) {
            return;
        }
        if (launcher == null || lastHoveredBlockPos != pos.func_218275_a()) {
            lastHoveredBlockPos = pos.func_218275_a();
            launcher = new EntityLauncher(Math.abs(validX + validZ), yDiff);
        }
        double totalFlyingTicks = launcher.getTotalFlyingTicks() + 3.0;
        int segments = (int)totalFlyingTicks / 3 + 1;
        double tickOffset = totalFlyingTicks / (double)segments;
        boolean valid = xDiff == validX && zDiff == validZ;
        int intColor = valid ? 10411635 : 0xFF7171;
        Vector3d color = ColorHelper.getRGB(intColor);
        RedstoneParticleData data = new RedstoneParticleData((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, 1.0f);
        ClientWorld world = mc.field_71441_e;
        AxisAlignedBB bb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0).func_186670_a(currentSelection.func_177982_a(-validX, -yDiff, -validZ));
        CreateClient.OUTLINER.chaseAABB("valid", bb).colored(intColor).lineWidth(0.0625f);
        for (int i = 0; i < segments; ++i) {
            double ticks = (double)(AnimationTickHolder.getRenderTime() / 3.0f) % tickOffset + (double)i * tickOffset;
            Vector3d vec = launcher.getGlobalPos(ticks, d, pos).func_72441_c((double)(xDiff - validX), 0.0, (double)(zDiff - validZ));
            world.func_195594_a((IParticleData)data, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, 0.0, 0.0);
        }
    }

    private static void checkForWrench(ItemStack heldItem) {
        if (!AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
        if (!(objectMouseOver instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)objectMouseOver;
        BlockPos pos = result.func_216350_a();
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
        if (!(te instanceof EjectorTileEntity)) {
            lastHoveredBlockPos = -1L;
            currentSelection = null;
            return;
        }
        if (lastHoveredBlockPos == -1L || lastHoveredBlockPos != pos.func_218275_a()) {
            EjectorTileEntity ejector = (EjectorTileEntity)te;
            if (!ejector.getTargetPosition().equals((Object)ejector.func_174877_v())) {
                currentSelection = ejector.getTargetPosition();
            }
            lastHoveredBlockPos = pos.func_218275_a();
            launcher = null;
        }
        if (lastHoveredBlockPos != -1L) {
            EjectorTargetHandler.drawOutline(currentSelection);
        }
    }

    private static void drawOutline(BlockPos selection) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (currentSelection == null) {
            return;
        }
        BlockPos pos = currentSelection;
        BlockState state = world.func_180495_p(pos);
        VoxelShape shape = state.func_196954_c((IBlockReader)world, pos);
        AxisAlignedBB boundingBox = shape.func_197766_b() ? new AxisAlignedBB(BlockPos.field_177992_a) : shape.func_197752_a();
        CreateClient.OUTLINER.showAABB("target", boundingBox.func_186670_a(pos)).colored(16763764).lineWidth(0.0625f);
    }

    static {
        lastHoveredBlockPos = -1L;
    }
}

