/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.instancing.InstanceMaterial;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.RotatingData;
import com.simibubi.create.content.contraptions.base.SingleRotatingInstance;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmBlock;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmRenderer;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.MatrixStacker;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ArmInstance
extends SingleRotatingInstance
implements IDynamicInstance {
    final ModelData base;
    final ModelData lowerBody;
    final ModelData upperBody;
    final ModelData head;
    final ModelData claw;
    private final ArrayList<ModelData> clawGrips;
    private final ArrayList<ModelData> models;
    private final ArmTileEntity arm;
    private final Boolean ceiling;
    private boolean firstRender = true;
    private float baseAngle = Float.NaN;
    private float lowerArmAngle = Float.NaN;
    private float upperArmAngle = Float.NaN;
    private float headAngle = Float.NaN;

    public ArmInstance(MaterialManager<?> modelManager, ArmTileEntity tile) {
        super(modelManager, tile);
        InstanceMaterial mat = this.getTransformMaterial();
        this.base = (ModelData)mat.getModel(AllBlockPartials.ARM_BASE, this.blockState).createInstance();
        this.lowerBody = (ModelData)mat.getModel(AllBlockPartials.ARM_LOWER_BODY, this.blockState).createInstance();
        this.upperBody = (ModelData)mat.getModel(AllBlockPartials.ARM_UPPER_BODY, this.blockState).createInstance();
        this.head = (ModelData)mat.getModel(AllBlockPartials.ARM_HEAD, this.blockState).createInstance();
        this.claw = (ModelData)mat.getModel(AllBlockPartials.ARM_CLAW_BASE, this.blockState).createInstance();
        Instancer clawHalfModel = mat.getModel(AllBlockPartials.ARM_CLAW_GRIP, this.blockState);
        ModelData clawGrip1 = (ModelData)clawHalfModel.createInstance();
        ModelData clawGrip2 = (ModelData)clawHalfModel.createInstance();
        this.clawGrips = Lists.newArrayList((Object[])new ModelData[]{clawGrip1, clawGrip2});
        this.models = Lists.newArrayList((Object[])new ModelData[]{this.base, this.lowerBody, this.upperBody, this.head, this.claw, clawGrip1, clawGrip2});
        this.arm = tile;
        this.ceiling = (Boolean)this.blockState.func_177229_b((Property)ArmBlock.CEILING);
        this.animateArm(false);
    }

    public void beginFrame() {
        if (this.arm.phase == ArmTileEntity.Phase.DANCING && ((KineticTileEntity)this.tile).getSpeed() != 0.0f) {
            this.animateArm(true);
            this.firstRender = true;
            return;
        }
        float pt = AnimationTickHolder.getPartialTicks();
        float baseAngleNow = this.arm.baseAngle.get(pt);
        float lowerArmAngleNow = this.arm.lowerArmAngle.get(pt);
        float upperArmAngleNow = this.arm.upperArmAngle.get(pt);
        float headAngleNow = this.arm.headAngle.get(pt);
        boolean settled = MathHelper.func_180185_a((float)this.baseAngle, (float)baseAngleNow) && MathHelper.func_180185_a((float)this.lowerArmAngle, (float)lowerArmAngleNow) && MathHelper.func_180185_a((float)this.upperArmAngle, (float)upperArmAngleNow) && MathHelper.func_180185_a((float)this.headAngle, (float)headAngleNow);
        this.baseAngle = baseAngleNow;
        this.lowerArmAngle = lowerArmAngleNow;
        this.upperArmAngle = upperArmAngleNow;
        this.headAngle = headAngleNow;
        if (!settled || this.firstRender) {
            this.animateArm(false);
        }
        if (this.firstRender) {
            this.firstRender = false;
        }
    }

    private void animateArm(boolean rave) {
        int color;
        float headAngle;
        float upperArmAngle;
        float lowerArmAngle;
        float baseAngle;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime((IWorld)this.arm.func_145831_w()) + (float)(((KineticTileEntity)this.tile).hashCode() % 64);
            baseAngle = renderTick * 10.0f % 360.0f;
            lowerArmAngle = MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (float)-45.0f, (float)15.0f);
            upperArmAngle = MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (float)-45.0f, (float)95.0f);
            headAngle = -lowerArmAngle;
            color = ColorHelper.rainbowColor(AnimationTickHolder.getTicks() * 100);
        } else {
            baseAngle = this.baseAngle;
            lowerArmAngle = this.lowerArmAngle - 135.0f;
            upperArmAngle = this.upperArmAngle - 90.0f;
            headAngle = this.headAngle;
            color = 0xFFFFFF;
        }
        MatrixStack msLocal = new MatrixStack();
        MatrixStacker msr = MatrixStacker.of(msLocal);
        msr.translate((Vector3i)this.getInstancePosition());
        msr.centre();
        if (this.ceiling.booleanValue()) {
            msr.rotateX(180.0);
        }
        ArmRenderer.transformBase(msr, baseAngle);
        this.base.setTransform(msLocal);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        this.lowerBody.setTransform(msLocal).setColor(color);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        this.upperBody.setTransform(msLocal).setColor(color);
        ArmRenderer.transformHead(msr, headAngle);
        this.head.setTransform(msLocal);
        ArmRenderer.transformClaw(msr);
        this.claw.setTransform(msLocal);
        ItemStack item = this.arm.heldItem;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        boolean hasItem = !item.func_190926_b();
        boolean isBlockItem = hasItem && item.func_77973_b() instanceof BlockItem && itemRenderer.func_184393_a(item, (World)Minecraft.func_71410_x().field_71441_e, null).func_177556_c();
        for (int index : Iterate.zeroAndOne) {
            msLocal.func_227860_a_();
            int flip = index * 2 - 1;
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            this.clawGrips.get(index).setTransform(msLocal);
            msLocal.func_227865_b_();
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, this.models.stream());
    }

    @Override
    protected Instancer<RotatingData> getModel() {
        return this.getRotatingMaterial().getModel(AllBlockPartials.ARM_COG, ((KineticTileEntity)this.tile).func_195044_w());
    }

    @Override
    public void remove() {
        super.remove();
        this.models.forEach(InstanceData::delete);
    }
}

