/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.components.deployer.DeployerBlock;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.block.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmAngleTarget;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class ArmInteractionPoint {
    protected BlockPos pos;
    protected BlockState state;
    protected Mode mode;
    protected LazyOptional<IItemHandler> cachedHandler = LazyOptional.empty();
    protected ArmAngleTarget cachedAngles;
    protected static final HashMap<ArmInteractionPoint, Supplier<ArmInteractionPoint>> POINTS = new HashMap();

    public static void addPoint(ArmInteractionPoint instance, Supplier<ArmInteractionPoint> factory) {
        if (POINTS.containsKey(instance)) {
            Create.LOGGER.warn("Point for " + instance.getClass().getSimpleName() + " was overridden");
        }
        POINTS.put(instance, factory);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void transformFlag(MatrixStack stack) {
    }

    protected PartialModel getFlagType() {
        return this.mode == Mode.TAKE ? AllBlockPartials.FLAG_LONG_OUT : AllBlockPartials.FLAG_LONG_IN;
    }

    protected void cycleMode() {
        this.mode = this.mode == Mode.DEPOSIT ? Mode.TAKE : Mode.DEPOSIT;
    }

    protected Vector3d getInteractionPositionVector() {
        return VecHelper.getCenterOf((Vector3i)this.pos);
    }

    protected Direction getInteractionDirection() {
        return Direction.DOWN;
    }

    protected boolean isStillValid(IBlockReader reader) {
        return this.isValid(reader, this.pos, reader.func_180495_p(this.pos));
    }

    protected void keepAlive(IWorld world) {
    }

    protected abstract boolean isValid(IBlockReader var1, BlockPos var2, BlockState var3);

    protected static boolean isInteractable(IBlockReader reader, BlockPos pos, BlockState state) {
        for (ArmInteractionPoint armInteractionPoint : POINTS.keySet()) {
            if (!armInteractionPoint.isValid(reader, pos, state)) continue;
            return true;
        }
        return false;
    }

    protected ArmAngleTarget getTargetAngles(BlockPos armPos, boolean ceiling) {
        if (this.cachedAngles == null) {
            this.cachedAngles = new ArmAngleTarget(armPos, this.getInteractionPositionVector(), this.getInteractionDirection(), ceiling);
        }
        return this.cachedAngles;
    }

    @Nullable
    protected IItemHandler getHandler(World world) {
        if (!this.cachedHandler.isPresent()) {
            TileEntity te = world.func_175625_s(this.pos);
            if (te == null) {
                return null;
            }
            this.cachedHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        }
        return (IItemHandler)this.cachedHandler.orElse(null);
    }

    protected ItemStack insert(World world, ItemStack stack, boolean simulate) {
        IItemHandler handler = this.getHandler(world);
        if (handler == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    protected ItemStack extract(World world, int slot, int amount, boolean simulate) {
        IItemHandler handler = this.getHandler(world);
        if (handler == null) {
            return ItemStack.field_190927_a;
        }
        return handler.extractItem(slot, amount, simulate);
    }

    protected ItemStack extract(World world, int slot, boolean simulate) {
        return this.extract(world, slot, 64, simulate);
    }

    protected int getSlotCount(World world) {
        IItemHandler handler = this.getHandler(world);
        if (handler == null) {
            return 0;
        }
        return handler.getSlots();
    }

    @Nullable
    protected static ArmInteractionPoint createAt(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        ArmInteractionPoint point = null;
        for (ArmInteractionPoint armInteractionPoint : POINTS.keySet()) {
            if (!armInteractionPoint.isValid(world, pos, state)) continue;
            point = POINTS.get(armInteractionPoint).get();
        }
        if (point != null) {
            point.state = state;
            point.pos = pos;
            point.mode = Mode.DEPOSIT;
        }
        return point;
    }

    protected CompoundNBT serialize(BlockPos anchor) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos.func_177973_b((Vector3i)anchor)));
        NBTHelper.writeEnum(nbt, "Mode", this.mode);
        return nbt;
    }

    protected static ArmInteractionPoint deserialize(IBlockReader world, BlockPos anchor, CompoundNBT nbt) {
        BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Pos"));
        ArmInteractionPoint interactionPoint = ArmInteractionPoint.createAt(world, pos.func_177971_a((Vector3i)anchor));
        if (interactionPoint == null) {
            return null;
        }
        interactionPoint.mode = NBTHelper.readEnum(nbt, "Mode", Mode.class);
        return interactionPoint;
    }

    static {
        ArmInteractionPoint.addPoint(new Saw(), Saw::new);
        ArmInteractionPoint.addPoint(new Belt(), Belt::new);
        ArmInteractionPoint.addPoint(new Depot(), Depot::new);
        ArmInteractionPoint.addPoint(new Chute(), Chute::new);
        ArmInteractionPoint.addPoint(new Basin(), Basin::new);
        ArmInteractionPoint.addPoint(new Funnel(), Funnel::new);
        ArmInteractionPoint.addPoint(new Jukebox(), Jukebox::new);
        ArmInteractionPoint.addPoint(new Crafter(), Crafter::new);
        ArmInteractionPoint.addPoint(new Deployer(), Deployer::new);
        ArmInteractionPoint.addPoint(new Composter(), Composter::new);
        ArmInteractionPoint.addPoint(new Millstone(), Millstone::new);
        ArmInteractionPoint.addPoint(new BlazeBurner(), BlazeBurner::new);
        ArmInteractionPoint.addPoint(new CrushingWheels(), CrushingWheels::new);
    }

    public static class Funnel
    extends ArmInteractionPoint {
        @Override
        protected Vector3d getInteractionPositionVector() {
            return VecHelper.getCenterOf((Vector3i)this.pos).func_178787_e(Vector3d.func_237491_b_((Vector3i)FunnelBlock.getFunnelFacing(this.state).func_176730_m()).func_186678_a((double)-0.15f));
        }

        @Override
        protected int getSlotCount(World world) {
            return 0;
        }

        @Override
        protected ItemStack extract(World world, int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        @Override
        protected Direction getInteractionDirection() {
            return FunnelBlock.getFunnelFacing(this.state).func_176734_d();
        }

        @Override
        protected ItemStack insert(World world, ItemStack stack, boolean simulate) {
            TileEntity tileEntity;
            FilteringBehaviour filtering = TileEntityBehaviour.get((IBlockReader)world, this.pos, FilteringBehaviour.TYPE);
            InvManipulationBehaviour inserter = TileEntityBehaviour.get((IBlockReader)world, this.pos, InvManipulationBehaviour.TYPE);
            BlockState state = world.func_180495_p(this.pos);
            if (state.func_235903_d_((Property)BlockStateProperties.field_208194_u).orElse(false).booleanValue()) {
                return stack;
            }
            if (inserter == null) {
                return stack;
            }
            if (filtering != null && !filtering.test(stack)) {
                return stack;
            }
            if (simulate) {
                inserter.simulate();
            }
            ItemStack insert = inserter.insert(stack);
            if (!simulate && insert.func_190916_E() != stack.func_190916_E() && (tileEntity = world.func_175625_s(this.pos)) instanceof FunnelTileEntity) {
                FunnelTileEntity funnelTileEntity = (FunnelTileEntity)tileEntity;
                funnelTileEntity.onTransfer(stack);
                if (funnelTileEntity.hasFlap()) {
                    funnelTileEntity.flap(true);
                }
            }
            return insert;
        }

        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return !(!(state.func_177230_c() instanceof AbstractFunnelBlock) || state.func_235901_b_((Property)FunnelBlock.EXTRACTING) && (Boolean)state.func_177229_b((Property)FunnelBlock.EXTRACTING) != false || state.func_235901_b_(BeltFunnelBlock.SHAPE) && state.func_177229_b(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.PUSHING);
        }

        @Override
        protected void cycleMode() {
        }
    }

    public static class Chute
    extends TopFaceArmInteractionPoint {
        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return AbstractChuteBlock.isChute(state);
        }
    }

    public static class Belt
    extends Depot {
        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return AllBlocks.BELT.has(state) && !(reader.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BeltTunnelBlock);
        }

        @Override
        protected void keepAlive(IWorld world) {
            super.keepAlive(world);
            BeltTileEntity beltTE = BeltHelper.getSegmentTE(world, this.pos);
            if (beltTE == null) {
                return;
            }
            TransportedItemStackHandlerBehaviour transport = beltTE.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
            if (transport == null) {
                return;
            }
            MutableBoolean found = new MutableBoolean(false);
            transport.handleProcessingOnAllItems(tis -> {
                if (found.isTrue()) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                tis.lockedExternally = true;
                found.setTrue();
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
        }
    }

    public static class Jukebox
    extends TopFaceArmInteractionPoint {
        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return state.func_177230_c() instanceof JukeboxBlock;
        }

        @Override
        protected int getSlotCount(World world) {
            return 1;
        }

        @Override
        protected ItemStack insert(World world, ItemStack stack, boolean simulate) {
            TileEntity tileEntity = world.func_175625_s(this.pos);
            if (!(tileEntity instanceof JukeboxTileEntity)) {
                return stack;
            }
            if (!(this.state.func_177230_c() instanceof JukeboxBlock)) {
                return stack;
            }
            JukeboxBlock jukeboxBlock = (JukeboxBlock)this.state.func_177230_c();
            JukeboxTileEntity jukeboxTE = (JukeboxTileEntity)tileEntity;
            if (!jukeboxTE.func_195537_c().func_190926_b()) {
                return stack;
            }
            if (!(stack.func_77973_b() instanceof MusicDiscItem)) {
                return stack;
            }
            ItemStack remainder = stack.func_77946_l();
            ItemStack toInsert = remainder.func_77979_a(1);
            if (!simulate && !world.field_72995_K) {
                jukeboxBlock.func_176431_a((IWorld)world, this.pos, this.state, toInsert);
                world.func_217378_a(null, 1010, this.pos, Item.func_150891_b((Item)toInsert.func_77973_b()));
                AllTriggers.triggerForNearbyPlayers(AllTriggers.MUSICAL_ARM, (IWorld)world, this.pos, 10);
            }
            return remainder;
        }

        @Override
        protected ItemStack extract(World world, int slot, int amount, boolean simulate) {
            TileEntity tileEntity = world.func_175625_s(this.pos);
            if (!(tileEntity instanceof JukeboxTileEntity)) {
                return ItemStack.field_190927_a;
            }
            if (!(this.state.func_177230_c() instanceof JukeboxBlock)) {
                return ItemStack.field_190927_a;
            }
            JukeboxTileEntity jukeboxTE = (JukeboxTileEntity)tileEntity;
            ItemStack itemstack = jukeboxTE.func_195537_c();
            if (itemstack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (!simulate && !world.field_72995_K) {
                world.func_217379_c(1010, this.pos, 0);
                jukeboxTE.func_174888_l();
                world.func_180501_a(this.pos, (BlockState)this.state.func_206870_a((Property)JukeboxBlock.field_176432_a, (Comparable)Boolean.valueOf(false)), 2);
            }
            return itemstack;
        }
    }

    public static class Basin
    extends ArmInteractionPoint {
        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return AllBlocks.BASIN.has(state);
        }
    }

    public static class Crafter
    extends ArmInteractionPoint {
        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return AllBlocks.MECHANICAL_CRAFTER.has(state);
        }

        @Override
        protected Direction getInteractionDirection() {
            return ((Direction)this.state.func_177229_b(MechanicalCrafterBlock.HORIZONTAL_FACING)).func_176734_d();
        }

        @Override
        protected ItemStack extract(World world, int slot, int amount, boolean simulate) {
            TileEntity te = world.func_175625_s(this.pos);
            if (!(te instanceof MechanicalCrafterTileEntity)) {
                return ItemStack.field_190927_a;
            }
            MechanicalCrafterTileEntity crafter = (MechanicalCrafterTileEntity)te;
            MechanicalCrafterTileEntity.Inventory inventory = crafter.getInventory();
            inventory.allowExtraction();
            ItemStack extract = super.extract(world, slot, amount, simulate);
            inventory.forbidExtraction();
            return extract;
        }

        @Override
        protected Vector3d getInteractionPositionVector() {
            return super.getInteractionPositionVector().func_178787_e(Vector3d.func_237491_b_((Vector3i)this.getInteractionDirection().func_176730_m()).func_186678_a(0.5));
        }
    }

    public static class BlazeBurner
    extends ArmInteractionPoint {
        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return AllBlocks.BLAZE_BURNER.has(state);
        }

        @Override
        protected ItemStack extract(World world, int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        @Override
        protected ItemStack insert(World world, ItemStack stack, boolean simulate) {
            ItemStack input = stack.func_77946_l();
            if (!((ItemStack)BlazeBurnerBlock.tryInsert(this.state, world, this.pos, input, false, true).func_188398_b()).func_190926_b()) {
                return stack;
            }
            ActionResult<ItemStack> res = BlazeBurnerBlock.tryInsert(this.state, world, this.pos, input, false, simulate);
            return res.func_188397_a() == ActionResultType.SUCCESS ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1)) : stack;
        }

        @Override
        protected void cycleMode() {
        }
    }

    public static class Deployer
    extends ArmInteractionPoint {
        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return AllBlocks.DEPLOYER.has(state);
        }

        @Override
        protected Direction getInteractionDirection() {
            return ((Direction)this.state.func_177229_b((Property)DeployerBlock.FACING)).func_176734_d();
        }

        @Override
        protected Vector3d getInteractionPositionVector() {
            return super.getInteractionPositionVector().func_178787_e(Vector3d.func_237491_b_((Vector3i)this.getInteractionDirection().func_176730_m()).func_186678_a((double)0.65f));
        }
    }

    public static class Composter
    extends TopFaceArmInteractionPoint {
        @Override
        protected Vector3d getInteractionPositionVector() {
            return Vector3d.func_237491_b_((Vector3i)this.pos).func_72441_c(0.5, 0.8125, 0.5);
        }

        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return Blocks.field_222436_lZ.equals(state.func_177230_c());
        }

        @Override
        @Nullable
        protected IItemHandler getHandler(World world) {
            return new InvWrapper((IInventory)((ComposterBlock)Blocks.field_222436_lZ).func_219966_a(world.func_180495_p(this.pos), (IWorld)world, this.pos));
        }
    }

    public static class CrushingWheels
    extends TopFaceArmInteractionPoint {
        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(state);
        }
    }

    public static class Millstone
    extends ArmInteractionPoint {
        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return AllBlocks.MILLSTONE.has(state);
        }
    }

    public static class Saw
    extends Depot {
        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return AllBlocks.MECHANICAL_SAW.has(state) && state.func_177229_b((Property)SawBlock.FACING) == Direction.UP && ((KineticTileEntity)reader.func_175625_s(pos)).getSpeed() != 0.0f;
        }
    }

    public static class Depot
    extends ArmInteractionPoint {
        @Override
        protected Vector3d getInteractionPositionVector() {
            return Vector3d.func_237491_b_((Vector3i)this.pos).func_72441_c(0.5, 0.875, 0.5);
        }

        @Override
        protected boolean isValid(IBlockReader reader, BlockPos pos, BlockState state) {
            return AllBlocks.DEPOT.has(state) || AllBlocks.WEIGHTED_EJECTOR.has(state);
        }
    }

    public static abstract class TopFaceArmInteractionPoint
    extends ArmInteractionPoint {
        @Override
        protected Vector3d getInteractionPositionVector() {
            return Vector3d.func_237491_b_((Vector3i)this.pos).func_72441_c(0.5, 1.0, 0.5);
        }
    }

    public static enum Mode {
        DEPOSIT,
        TAKE;

    }
}

