/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.redstone.AnalogLeverBlock;
import com.simibubi.create.content.logistics.block.redstone.AnalogLeverTileEntity;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ColorHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;

public class AnalogLeverRenderer
extends SafeTileEntityRenderer<AnalogLeverTileEntity> {
    public AnalogLeverRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(AnalogLeverTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            return;
        }
        BlockState leverState = te.func_195044_w();
        int lightCoords = WorldRenderer.func_228420_a_((IBlockDisplayReader)te.func_145831_w(), (BlockState)leverState, (BlockPos)te.func_174877_v());
        float state = te.clientState.get(partialTicks);
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        SuperByteBuffer handle = PartialBufferer.get(AllBlockPartials.ANALOG_LEVER_HANDLE, leverState);
        float angle = (float)((double)(state / 15.0f * 90.0f / 180.0f) * Math.PI);
        this.transform(handle, leverState).translate(0.5f, 0.0625f, 0.5f).rotate(Direction.EAST, angle).translate(-0.5f, -0.0625f, -0.5f);
        handle.light(lightCoords).renderInto(ms, vb);
        int color = ColorHelper.mixColors(2884352, 0xCD0000, state / 15.0f);
        SuperByteBuffer indicator = this.transform(PartialBufferer.get(AllBlockPartials.ANALOG_LEVER_INDICATOR, leverState), leverState);
        indicator.light(lightCoords).color(color).renderInto(ms, vb);
    }

    private SuperByteBuffer transform(SuperByteBuffer buffer, BlockState leverState) {
        AttachFace face = (AttachFace)leverState.func_177229_b((Property)AnalogLeverBlock.field_196366_M);
        float rX = face == AttachFace.FLOOR ? 0.0f : (face == AttachFace.WALL ? 90.0f : 180.0f);
        float rY = AngleHelper.horizontalAngle((Direction)leverState.func_177229_b((Property)AnalogLeverBlock.field_185512_D));
        buffer.rotateCentered(Direction.UP, (float)((double)(rY / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.EAST, (float)((double)(rX / 180.0f) * Math.PI));
        return buffer;
    }
}

