/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterContainer;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class FilterItem
extends Item
implements INamedContainerProvider {
    private FilterType type;

    public static FilterItem regular(Item.Properties properties) {
        return new FilterItem(FilterType.REGULAR, properties);
    }

    public static FilterItem attribute(Item.Properties properties) {
        return new FilterItem(FilterType.ATTRIBUTE, properties);
    }

    private FilterItem(FilterType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j() == null) {
            return ActionResultType.PASS;
        }
        return this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!AllKeys.shiftDown()) {
            List<ITextComponent> makeSummary = this.makeSummary(stack);
            if (makeSummary.isEmpty()) {
                return;
            }
            ItemDescription.add(tooltip, (ITextComponent)new StringTextComponent(" "));
            ItemDescription.add(tooltip, makeSummary);
        }
    }

    private List<ITextComponent> makeSummary(ItemStack filter) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (this.type == FilterType.REGULAR) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean blacklist = filter.func_196082_o().func_74767_n("Blacklist");
            list.add((ITextComponent)(blacklist ? Lang.translate("gui.filter.deny_list", new Object[0]) : Lang.translate("gui.filter.allow_list", new Object[0])).func_240699_a_(TextFormatting.GOLD));
            int count = 0;
            for (int i = 0; i < filterItems.getSlots(); ++i) {
                if (count > 3) {
                    list.add((ITextComponent)new StringTextComponent("- ...").func_240699_a_(TextFormatting.DARK_GRAY));
                    break;
                }
                ItemStack filterStack = filterItems.getStackInSlot(i);
                if (filterStack.func_190926_b()) continue;
                list.add((ITextComponent)new StringTextComponent("- ").func_230529_a_(filterStack.func_200301_q()).func_240699_a_(TextFormatting.GRAY));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        if (this.type == FilterType.ATTRIBUTE) {
            AttributeFilterContainer.WhitelistMode whitelistMode = AttributeFilterContainer.WhitelistMode.values()[filter.func_196082_o().func_74762_e("WhitelistMode")];
            list.add((ITextComponent)(whitelistMode == AttributeFilterContainer.WhitelistMode.WHITELIST_CONJ ? Lang.translate("gui.attribute_filter.allow_list_conjunctive", new Object[0]) : (whitelistMode == AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ ? Lang.translate("gui.attribute_filter.allow_list_disjunctive", new Object[0]) : Lang.translate("gui.attribute_filter.deny_list", new Object[0]))).func_240699_a_(TextFormatting.GOLD));
            int count = 0;
            ListNBT attributes = filter.func_196082_o().func_150295_c("MatchedAttributes", 10);
            for (INBT inbt : attributes) {
                CompoundNBT compound = (CompoundNBT)inbt;
                ItemAttribute attribute = ItemAttribute.fromNBT(compound);
                boolean inverted = compound.func_74767_n("Inverted");
                if (count > 3) {
                    list.add((ITextComponent)new StringTextComponent("- ...").func_240699_a_(TextFormatting.DARK_GRAY));
                    break;
                }
                list.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)attribute.format(inverted)));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        return list;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!player.func_225608_bj_() && hand == Hand.MAIN_HAND) {
            if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.func_150788_a(heldItem));
            }
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        return ActionResult.func_226250_c_((Object)heldItem);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (this.type == FilterType.REGULAR) {
            return FilterContainer.create(id, inv, heldItem);
        }
        if (this.type == FilterType.ATTRIBUTE) {
            return AttributeFilterContainer.create(id, inv, heldItem);
        }
        return null;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_77658_a());
    }

    public static ItemStackHandler getFilterItems(ItemStack stack) {
        ItemStackHandler newInv = new ItemStackHandler(18);
        if (AllItems.FILTER.get() != stack.func_77973_b()) {
            throw new IllegalArgumentException("Cannot get filter items from non-filter: " + stack);
        }
        CompoundNBT invNBT = stack.func_190925_c("Items");
        if (!invNBT.isEmpty()) {
            newInv.deserializeNBT(invNBT);
        }
        return newInv;
    }

    public static boolean test(World world, ItemStack stack, ItemStack filter) {
        return FilterItem.test(world, stack, filter, false);
    }

    public static boolean test(World world, FluidStack stack, ItemStack filter) {
        return FilterItem.test(world, stack, filter, true);
    }

    private static boolean test(World world, ItemStack stack, ItemStack filter, boolean matchNBT) {
        if (filter.func_190926_b()) {
            return true;
        }
        if (!(filter.func_77973_b() instanceof FilterItem)) {
            return matchNBT ? ItemHandlerHelper.canItemStacksStack((ItemStack)filter, (ItemStack)stack) : ItemStack.func_179545_c((ItemStack)filter, (ItemStack)stack);
        }
        if (AllItems.FILTER.get() == filter.func_77973_b()) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean respectNBT = filter.func_196082_o().func_74767_n("RespectNBT");
            boolean blacklist = filter.func_196082_o().func_74767_n("Blacklist");
            for (int slot = 0; slot < filterItems.getSlots(); ++slot) {
                boolean matches;
                ItemStack stackInSlot = filterItems.getStackInSlot(slot);
                if (stackInSlot.func_190926_b() || !(matches = FilterItem.test(world, stack, stackInSlot, respectNBT))) continue;
                return !blacklist;
            }
            return blacklist;
        }
        if (AllItems.ATTRIBUTE_FILTER.get() == filter.func_77973_b()) {
            AttributeFilterContainer.WhitelistMode whitelistMode = AttributeFilterContainer.WhitelistMode.values()[filter.func_196082_o().func_74762_e("WhitelistMode")];
            ListNBT attributes = filter.func_196082_o().func_150295_c("MatchedAttributes", 10);
            block16: for (INBT inbt : attributes) {
                boolean matches;
                CompoundNBT compound = (CompoundNBT)inbt;
                ItemAttribute attribute = ItemAttribute.fromNBT(compound);
                boolean bl = matches = attribute.appliesTo(stack, world) != compound.func_74767_n("Inverted");
                if (matches) {
                    switch (whitelistMode) {
                        case BLACKLIST: {
                            return false;
                        }
                        case WHITELIST_CONJ: {
                            continue block16;
                        }
                        case WHITELIST_DISJ: {
                            return true;
                        }
                    }
                    continue;
                }
                switch (whitelistMode) {
                    case BLACKLIST: {
                        continue block16;
                    }
                    case WHITELIST_CONJ: {
                        return false;
                    }
                    case WHITELIST_DISJ: {
                        continue block16;
                    }
                }
            }
            switch (whitelistMode) {
                case BLACKLIST: {
                    return true;
                }
                case WHITELIST_CONJ: {
                    return true;
                }
                case WHITELIST_DISJ: {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean test(World world, FluidStack stack, ItemStack filter, boolean matchNBT) {
        if (filter.func_190926_b()) {
            return true;
        }
        if (stack.isEmpty()) {
            return false;
        }
        if (!(filter.func_77973_b() instanceof FilterItem)) {
            if (!EmptyingByBasin.canItemBeEmptied(world, filter)) {
                return false;
            }
            FluidStack fluidInFilter = EmptyingByBasin.emptyItem(world, filter, true).getFirst();
            if (fluidInFilter == null) {
                return false;
            }
            if (!matchNBT) {
                return fluidInFilter.getFluid().func_207187_a(stack.getFluid());
            }
            boolean fluidEqual = fluidInFilter.isFluidEqual(stack);
            return fluidEqual;
        }
        if (AllItems.FILTER.get() == filter.func_77973_b()) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean respectNBT = filter.func_196082_o().func_74767_n("RespectNBT");
            boolean blacklist = filter.func_196082_o().func_74767_n("Blacklist");
            for (int slot = 0; slot < filterItems.getSlots(); ++slot) {
                boolean matches;
                ItemStack stackInSlot = filterItems.getStackInSlot(slot);
                if (stackInSlot.func_190926_b() || !(matches = FilterItem.test(world, stack, stackInSlot, respectNBT))) continue;
                return !blacklist;
            }
            return blacklist;
        }
        return false;
    }

    private static enum FilterType {
        REGULAR,
        ATTRIBUTE;

    }
}

