/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementChecks;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.content.schematics.MaterialChecklist;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.item.SchematicItem;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class SchematicPrinter {
    private boolean schematicLoaded;
    private SchematicWorld blockReader;
    private BlockPos schematicAnchor;
    private BlockPos currentPos;
    private int printingEntityIndex = -1;
    private PrintStage printStage = PrintStage.BLOCKS;
    private List<BlockPos> deferredBlocks = new LinkedList<BlockPos>();

    public void fromTag(CompoundNBT compound, boolean clientPacket) {
        if (compound.func_74764_b("CurrentPos")) {
            this.currentPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("CurrentPos"));
        }
        this.printingEntityIndex = compound.func_74762_e("EntityProgress");
        this.printStage = PrintStage.valueOf(compound.func_74779_i("PrintStage"));
        compound.func_150295_c("DeferredBlocks", 10).stream().map(p -> NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)p))).collect(Collectors.toCollection(() -> this.deferredBlocks));
    }

    public void write(CompoundNBT compound) {
        if (this.currentPos != null) {
            compound.func_218657_a("CurrentPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.currentPos));
        }
        compound.func_74768_a("EntityProgress", this.printingEntityIndex);
        compound.func_74778_a("PrintStage", this.printStage.name());
        ListNBT tagDeferredBlocks = new ListNBT();
        for (BlockPos p : this.deferredBlocks) {
            tagDeferredBlocks.add((Object)NBTUtil.func_186859_a((BlockPos)p));
        }
        compound.func_218657_a("DeferredBlocks", (INBT)tagDeferredBlocks);
    }

    public void loadSchematic(ItemStack blueprint, World originalWorld, boolean processNBT) {
        if (!blueprint.func_77942_o() || !blueprint.func_77978_p().func_74767_n("Deployed")) {
            return;
        }
        Template activeTemplate = SchematicItem.loadSchematic(blueprint);
        PlacementSettings settings = SchematicItem.getSettings(blueprint, processNBT);
        this.schematicAnchor = NBTUtil.func_186861_c((CompoundNBT)blueprint.func_77978_p().func_74775_l("Anchor"));
        this.blockReader = new SchematicWorld(this.schematicAnchor, originalWorld);
        activeTemplate.func_237144_a_((IServerWorld)this.blockReader, this.schematicAnchor, settings, this.blockReader.func_201674_k());
        this.printingEntityIndex = -1;
        this.printStage = PrintStage.BLOCKS;
        this.deferredBlocks.clear();
        MutableBoundingBox bounds = this.blockReader.getBounds();
        this.currentPos = new BlockPos(bounds.field_78897_a - 1, bounds.field_78895_b, bounds.field_78896_c);
        this.schematicLoaded = true;
    }

    public void resetSchematic() {
        this.schematicLoaded = false;
        this.schematicAnchor = null;
        this.currentPos = null;
        this.blockReader = null;
        this.printingEntityIndex = -1;
        this.printStage = PrintStage.BLOCKS;
        this.deferredBlocks.clear();
    }

    public boolean isLoaded() {
        return this.schematicLoaded;
    }

    public BlockPos getCurrentTarget() {
        if (!this.isLoaded()) {
            return null;
        }
        return this.schematicAnchor.func_177971_a((Vector3i)this.currentPos);
    }

    public PrintStage getPrintStage() {
        return this.printStage;
    }

    public BlockPos getAnchor() {
        return this.schematicAnchor;
    }

    public boolean isWorldEmpty() {
        return this.blockReader.getAllPositions().isEmpty();
    }

    public void handleCurrentTarget(BlockTargetHandler blockHandler, EntityTargetHandler entityHandler) {
        BlockPos target = this.getCurrentTarget();
        if (this.printStage == PrintStage.ENTITIES) {
            Entity entity = (Entity)this.blockReader.getEntities().collect(Collectors.toList()).get(this.printingEntityIndex);
            entityHandler.handle(target, entity);
        } else {
            BlockState blockState = BlockHelper.setZeroAge(this.blockReader.func_180495_p(target));
            TileEntity tileEntity = this.blockReader.func_175625_s(target);
            blockHandler.handle(target, blockState, tileEntity);
        }
    }

    public boolean shouldPlaceCurrent(World world) {
        return this.shouldPlaceCurrent(world, (a, b, c, d, e, f) -> true);
    }

    public boolean shouldPlaceCurrent(World world, PlacementPredicate predicate) {
        if (world == null) {
            return false;
        }
        if (this.printStage == PrintStage.ENTITIES) {
            return true;
        }
        return this.shouldPlaceBlock(world, predicate, this.getCurrentTarget());
    }

    public boolean shouldPlaceBlock(World world, PlacementPredicate predicate, BlockPos pos) {
        BlockState state = BlockHelper.setZeroAge(this.blockReader.func_180495_p(pos));
        TileEntity tileEntity = this.blockReader.func_175625_s(pos);
        BlockState toReplace = world.func_180495_p(pos);
        BlockState toReplaceOther = null;
        if (state.func_235901_b_((Property)BlockStateProperties.field_208139_an) && state.func_235901_b_((Property)BlockStateProperties.field_208157_J) && state.func_177229_b((Property)BlockStateProperties.field_208139_an) == BedPart.FOOT) {
            toReplaceOther = world.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208163_P) && state.func_177229_b((Property)BlockStateProperties.field_208163_P) == DoubleBlockHalf.LOWER) {
            toReplaceOther = world.func_180495_p(pos.func_177984_a());
        }
        if (!world.func_195588_v(pos)) {
            return false;
        }
        if (!world.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        if (toReplace == state) {
            return false;
        }
        if (toReplace.func_185887_b((IBlockReader)world, pos) == -1.0f || toReplaceOther != null && toReplaceOther.func_185887_b((IBlockReader)world, pos) == -1.0f) {
            return false;
        }
        boolean isNormalCube = state.func_215686_e((IBlockReader)this.blockReader, this.currentPos);
        return predicate.shouldPlace(pos, state, tileEntity, toReplace, toReplaceOther, isNormalCube);
    }

    public ItemRequirement getCurrentRequirement() {
        if (this.printStage == PrintStage.ENTITIES) {
            return ItemRequirement.of((Entity)this.blockReader.getEntities().collect(Collectors.toList()).get(this.printingEntityIndex));
        }
        BlockPos target = this.getCurrentTarget();
        BlockState blockState = BlockHelper.setZeroAge(this.blockReader.func_180495_p(target));
        TileEntity tileEntity = this.blockReader.func_175625_s(target);
        return ItemRequirement.of(blockState, tileEntity);
    }

    public int markAllBlockRequirements(MaterialChecklist checklist, World world, PlacementPredicate predicate) {
        int blocksToPlace = 0;
        for (BlockPos pos : this.blockReader.getAllPositions()) {
            ItemRequirement requirement;
            BlockPos relPos = pos.func_177971_a((Vector3i)this.schematicAnchor);
            BlockState required = this.blockReader.func_180495_p(relPos);
            TileEntity requiredTE = this.blockReader.func_175625_s(relPos);
            if (!world.isAreaLoaded(pos.func_177971_a((Vector3i)this.schematicAnchor), 0)) {
                checklist.warnBlockNotLoaded();
                continue;
            }
            if (!this.shouldPlaceBlock(world, predicate, relPos) || (requirement = ItemRequirement.of(required, requiredTE)).isEmpty() || requirement.isInvalid()) continue;
            checklist.require(requirement);
            ++blocksToPlace;
        }
        return blocksToPlace;
    }

    public void markAllEntityRequirements(MaterialChecklist checklist) {
        this.blockReader.getEntities().forEach(entity -> {
            ItemRequirement requirement = ItemRequirement.of(entity);
            if (requirement.isEmpty()) {
                return;
            }
            if (requirement.isInvalid()) {
                return;
            }
            checklist.require(requirement);
        });
    }

    public boolean advanceCurrentPos() {
        List entities = this.blockReader.getEntities().collect(Collectors.toList());
        do {
            if (this.printStage == PrintStage.BLOCKS) {
                while (this.tryAdvanceCurrentPos()) {
                    this.deferredBlocks.add(this.currentPos);
                }
            }
            if (this.printStage == PrintStage.DEFERRED_BLOCKS) {
                if (this.deferredBlocks.isEmpty()) {
                    this.printStage = PrintStage.ENTITIES;
                } else {
                    this.currentPos = this.deferredBlocks.remove(0);
                }
            }
            if (this.printStage != PrintStage.ENTITIES) continue;
            if (this.printingEntityIndex + 1 < entities.size()) {
                ++this.printingEntityIndex;
                this.currentPos = ((Entity)entities.get(this.printingEntityIndex)).func_233580_cy_().func_177973_b((Vector3i)this.schematicAnchor);
                continue;
            }
            return false;
        } while (!this.blockReader.getBounds().func_175898_b((Vector3i)this.currentPos));
        return true;
    }

    public boolean tryAdvanceCurrentPos() {
        this.currentPos = this.currentPos.func_177972_a(Direction.EAST);
        MutableBoundingBox bounds = this.blockReader.getBounds();
        BlockPos posInBounds = this.currentPos.func_177982_a(-bounds.field_78897_a, -bounds.field_78895_b, -bounds.field_78896_c);
        if (posInBounds.func_177958_n() > bounds.func_78883_b()) {
            this.currentPos = new BlockPos(bounds.field_78897_a, this.currentPos.func_177956_o(), this.currentPos.func_177952_p() + 1).func_177976_e();
        }
        if (posInBounds.func_177952_p() > bounds.func_78880_d()) {
            this.currentPos = new BlockPos(this.currentPos.func_177958_n(), this.currentPos.func_177956_o() + 1, bounds.field_78896_c).func_177976_e();
        }
        if (this.currentPos.func_177956_o() > bounds.func_78882_c()) {
            this.printStage = PrintStage.DEFERRED_BLOCKS;
            return false;
        }
        return SchematicPrinter.shouldDeferBlock(this.blockReader.func_180495_p(this.getCurrentTarget()));
    }

    public static boolean shouldDeferBlock(BlockState state) {
        return state.func_177230_c().func_235332_a_((Block)AllBlocks.GANTRY_CARRIAGE.get()) || BlockMovementChecks.isBrittle(state);
    }

    @FunctionalInterface
    public static interface PlacementPredicate {
        public boolean shouldPlace(BlockPos var1, BlockState var2, TileEntity var3, BlockState var4, BlockState var5, boolean var6);
    }

    @FunctionalInterface
    public static interface EntityTargetHandler {
        public void handle(BlockPos var1, Entity var2);
    }

    @FunctionalInterface
    public static interface BlockTargetHandler {
        public void handle(BlockPos var1, BlockState var2, TileEntity var3);
    }

    public static enum PrintStage {
        BLOCKS,
        DEFERRED_BLOCKS,
        ENTITIES;

    }
}

