/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.InstanceMaterial;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.tile.TileEntityInstance;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.schematics.block.SchematicannonRenderer;
import com.simibubi.create.content.schematics.block.SchematicannonTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3i;

public class SchematicannonInstance
extends TileEntityInstance<SchematicannonTileEntity>
implements IDynamicInstance {
    private final ModelData connector;
    private final ModelData pipe;

    public SchematicannonInstance(MaterialManager<?> modelManager, SchematicannonTileEntity tile) {
        super(modelManager, (TileEntity)tile);
        InstanceMaterial mat = this.getTransformMaterial();
        this.connector = (ModelData)mat.getModel(AllBlockPartials.SCHEMATICANNON_CONNECTOR, this.blockState).createInstance();
        this.pipe = (ModelData)mat.getModel(AllBlockPartials.SCHEMATICANNON_PIPE, this.blockState).createInstance();
        this.beginFrame();
    }

    public void beginFrame() {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        double[] cannonAngles = SchematicannonRenderer.getCannonAngles((SchematicannonTileEntity)this.tile, this.pos, partialTicks);
        double pitch = cannonAngles[0];
        double yaw = cannonAngles[1];
        double recoil = SchematicannonRenderer.getRecoil((SchematicannonTileEntity)this.tile, partialTicks);
        MatrixStack ms = new MatrixStack();
        MatrixStacker msr = MatrixStacker.of(ms);
        msr.translate((Vector3i)this.getInstancePosition());
        ms.func_227860_a_();
        msr.centre();
        msr.rotate(Direction.UP, (float)((yaw + 90.0) / 180.0 * Math.PI));
        msr.unCentre();
        this.connector.setTransform(ms);
        ms.func_227865_b_();
        msr.translate(0.5, 0.9375, 0.5);
        msr.rotate(Direction.UP, (float)((yaw + 90.0) / 180.0 * Math.PI));
        msr.rotate(Direction.SOUTH, (float)(pitch / 180.0 * Math.PI));
        msr.translate(-0.5, -0.9375, -0.5);
        msr.translate(0.0, -recoil / 100.0, 0.0);
        this.pipe.setTransform(ms);
    }

    public void remove() {
        this.connector.delete();
        this.pipe.delete();
    }

    public void updateLight() {
        this.relight(this.pos, new IFlatLight[]{this.connector, this.pipe});
    }
}

