/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.schematics.block.LaunchedItem;
import com.simibubi.create.content.schematics.block.SchematicannonTileEntity;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class SchematicannonRenderer
extends SafeTileEntityRenderer<SchematicannonTileEntity> {
    public SchematicannonRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean isGlobalRenderer(SchematicannonTileEntity p_188185_1_) {
        return true;
    }

    @Override
    protected void renderSafe(SchematicannonTileEntity tileEntityIn, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        boolean blocksLaunching;
        boolean bl = blocksLaunching = !tileEntityIn.flyingBlocks.isEmpty();
        if (blocksLaunching) {
            SchematicannonRenderer.renderLaunchedBlocks(tileEntityIn, partialTicks, ms, buffer, light, overlay);
        }
        if (Backend.getInstance().canUseInstancing(tileEntityIn.func_145831_w())) {
            return;
        }
        BlockPos pos = tileEntityIn.func_174877_v();
        double[] cannonAngles = SchematicannonRenderer.getCannonAngles(tileEntityIn, pos, partialTicks);
        double pitch = cannonAngles[0];
        double yaw = cannonAngles[1];
        double recoil = SchematicannonRenderer.getRecoil(tileEntityIn, partialTicks);
        ms.func_227860_a_();
        BlockState state = tileEntityIn.func_195044_w();
        int lightCoords = WorldRenderer.func_228421_a_((IBlockDisplayReader)tileEntityIn.func_145831_w(), (BlockPos)pos);
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        SuperByteBuffer connector = PartialBufferer.get(AllBlockPartials.SCHEMATICANNON_CONNECTOR, state);
        connector.translate(0.5f, 0.0f, 0.5f);
        connector.rotate(Direction.UP, (float)((yaw + 90.0) / 180.0 * Math.PI));
        connector.translate(-0.5f, 0.0f, -0.5f);
        connector.light(lightCoords).renderInto(ms, vb);
        SuperByteBuffer pipe = PartialBufferer.get(AllBlockPartials.SCHEMATICANNON_PIPE, state);
        pipe.translate(0.5f, 0.9375f, 0.5f);
        pipe.rotate(Direction.UP, (float)((yaw + 90.0) / 180.0 * Math.PI));
        pipe.rotate(Direction.SOUTH, (float)(pitch / 180.0 * Math.PI));
        pipe.translate(-0.5f, -0.9375f, -0.5f);
        pipe.translate(0.0, -recoil / 100.0, 0.0);
        pipe.light(lightCoords).renderInto(ms, vb);
        ms.func_227865_b_();
    }

    public static double[] getCannonAngles(SchematicannonTileEntity tile, BlockPos pos, float partialTicks) {
        double yaw = 0.0;
        double pitch = 40.0;
        BlockPos target = tile.printer.getCurrentTarget();
        if (target != null) {
            Vector3d diff = Vector3d.func_237491_b_((Vector3i)target.func_177973_b((Vector3i)pos));
            if (tile.previousTarget != null) {
                diff = Vector3d.func_237491_b_((Vector3i)tile.previousTarget).func_178787_e(Vector3d.func_237491_b_((Vector3i)target.func_177973_b((Vector3i)tile.previousTarget)).func_186678_a((double)partialTicks)).func_178788_d(Vector3d.func_237491_b_((Vector3i)pos));
            }
            double diffX = diff.func_82615_a();
            double diffZ = diff.func_82616_c();
            yaw = MathHelper.func_181159_b((double)diffX, (double)diffZ);
            yaw = yaw / Math.PI * 180.0;
            float distance = MathHelper.func_76133_a((double)(diffX * diffX + diffZ * diffZ));
            double yOffset = 0.0f + distance * 2.0f;
            pitch = MathHelper.func_181159_b((double)distance, (double)(diff.func_82617_b() * 3.0 + yOffset));
            pitch = pitch / Math.PI * 180.0 + 10.0;
        }
        return new double[]{pitch, yaw};
    }

    public static double getRecoil(SchematicannonTileEntity tileEntityIn, float partialTicks) {
        double recoil = 0.0;
        for (LaunchedItem launched : tileEntityIn.flyingBlocks) {
            if (launched.ticksRemaining == 0 || !((float)(launched.ticksRemaining + 1) - partialTicks > (float)(launched.totalTicks - 10))) continue;
            recoil = Math.max(recoil, (double)((float)(launched.ticksRemaining + 1) - partialTicks - (float)launched.totalTicks + 10.0f));
        }
        return recoil;
    }

    private static void renderLaunchedBlocks(SchematicannonTileEntity tileEntityIn, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        for (LaunchedItem launched : tileEntityIn.flyingBlocks) {
            float scale;
            if (launched.ticksRemaining == 0) continue;
            Vector3d start = Vector3d.func_237491_b_((Vector3i)tileEntityIn.func_174877_v().func_177963_a(0.5, 1.0, 0.5));
            Vector3d target = Vector3d.func_237491_b_((Vector3i)launched.target).func_72441_c(-0.5, 0.0, 1.0);
            Vector3d distance = target.func_178788_d(start);
            double targetY = target.field_72448_b - start.field_72448_b;
            double throwHeight = Math.sqrt(distance.func_189985_c()) * (double)0.6f + targetY;
            Vector3d cannonOffset = distance.func_72441_c(0.0, throwHeight, 0.0).func_72432_b().func_186678_a(2.0);
            start = start.func_178787_e(cannonOffset);
            float progress = ((float)launched.totalTicks - ((float)(launched.ticksRemaining + 1) - partialTicks)) / (float)launched.totalTicks;
            Vector3d blockLocationXZ = new Vector3d(0.5, 0.5, 0.5).func_178787_e(target.func_178788_d(start).func_186678_a((double)progress).func_216372_d(1.0, 0.0, 1.0));
            float t = progress;
            double yOffset = (double)(2.0f * (1.0f - t) * t) * throwHeight + (double)(t * t) * targetY;
            Vector3d blockLocation = blockLocationXZ.func_72441_c(0.0, yOffset + 1.0, 0.0).func_178787_e(cannonOffset);
            ms.func_227860_a_();
            ms.func_227861_a_(blockLocation.field_72450_a, blockLocation.field_72448_b, blockLocation.field_72449_c);
            ms.func_227863_a_(new Vector3f(0.0f, 1.0f, 0.0f).func_229187_a_(360.0f * t * 2.0f));
            ms.func_227863_a_(new Vector3f(1.0f, 0.0f, 0.0f).func_229187_a_(360.0f * t * 2.0f));
            if (launched instanceof LaunchedItem.ForBlockState) {
                scale = 0.3f;
                ms.func_227862_a_(scale, scale, scale);
                Minecraft.func_71410_x().func_175602_ab().renderBlock(((LaunchedItem.ForBlockState)launched).state, ms, buffer, light, overlay, (IModelData)EmptyModelData.INSTANCE);
            }
            if (launched instanceof LaunchedItem.ForEntity) {
                scale = 1.2f;
                ms.func_227862_a_(scale, scale, scale);
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(launched.stack, ItemCameraTransforms.TransformType.GROUND, light, overlay, ms, buffer);
            }
            ms.func_227865_b_();
            if (launched.ticksRemaining != launched.totalTicks || !tileEntityIn.firstRenderTick) continue;
            tileEntityIn.firstRenderTick = false;
            for (int i = 0; i < 10; ++i) {
                Random r = tileEntityIn.func_145831_w().func_201674_k();
                double sX = cannonOffset.field_72450_a * (double)0.01f;
                double sY = (cannonOffset.field_72448_b + 1.0) * (double)0.01f;
                double sZ = cannonOffset.field_72449_c * (double)0.01f;
                double rX = (double)r.nextFloat() - sX * 40.0;
                double rY = (double)r.nextFloat() - sY * 40.0;
                double rZ = (double)r.nextFloat() - sZ * 40.0;
                tileEntityIn.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197613_f, start.field_72450_a + rX, start.field_72448_b + rY, start.field_72449_c + rZ, sX, sY, sZ);
            }
        }
    }
}

