/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client.tools;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.content.schematics.client.tools.ISchematicTool;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.outliner.AABBOutline;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public abstract class SchematicToolBase
implements ISchematicTool {
    protected SchematicHandler schematicHandler;
    protected BlockPos selectedPos;
    protected Vector3d chasingSelectedPos;
    protected Vector3d lastChasingSelectedPos;
    protected boolean selectIgnoreBlocks;
    protected int selectionRange;
    protected boolean schematicSelected;
    protected boolean renderSelectedFace;
    protected Direction selectedFace;
    protected final List<String> mirrors = Arrays.asList("none", "leftRight", "frontBack");
    protected final List<String> rotations = Arrays.asList("none", "cw90", "cw180", "cw270");

    @Override
    public void init() {
        this.schematicHandler = CreateClient.SCHEMATIC_HANDLER;
        this.selectedPos = null;
        this.selectedFace = null;
        this.schematicSelected = false;
        this.chasingSelectedPos = Vector3d.field_186680_a;
        this.lastChasingSelectedPos = Vector3d.field_186680_a;
    }

    @Override
    public void updateSelection() {
        this.updateTargetPos();
        if (this.selectedPos == null) {
            return;
        }
        this.lastChasingSelectedPos = this.chasingSelectedPos;
        Vector3d target = Vector3d.func_237491_b_((Vector3i)this.selectedPos);
        if (target.func_72438_d(this.chasingSelectedPos) < 0.001953125) {
            this.chasingSelectedPos = target;
            return;
        }
        this.chasingSelectedPos = this.chasingSelectedPos.func_178787_e(target.func_178788_d(this.chasingSelectedPos).func_186678_a(0.5));
    }

    public void updateTargetPos() {
        boolean snap;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (this.schematicHandler.isDeployed()) {
            Vector3d end;
            SchematicTransformation transformation = this.schematicHandler.getTransformation();
            AxisAlignedBB localBounds = this.schematicHandler.getBounds();
            Vector3d traceOrigin = RaycastHelper.getTraceOrigin((PlayerEntity)player);
            Vector3d start = transformation.toLocalSpace(traceOrigin);
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil(start, end = transformation.toLocalSpace(RaycastHelper.getTraceTarget((PlayerEntity)player, 70.0, traceOrigin)), pos -> localBounds.func_72318_a(VecHelper.getCenterOf((Vector3i)pos)));
            this.schematicSelected = !result.missed();
            this.selectedFace = this.schematicSelected ? result.getFacing() : null;
        }
        boolean bl = snap = this.selectedPos == null;
        if (this.selectIgnoreBlocks) {
            float pt = AnimationTickHolder.getPartialTicks();
            this.selectedPos = new BlockPos(player.func_174824_e(pt).func_178787_e(player.func_70040_Z().func_186678_a((double)this.selectionRange)));
            if (snap) {
                this.lastChasingSelectedPos = this.chasingSelectedPos = Vector3d.func_237491_b_((Vector3i)this.selectedPos);
            }
            return;
        }
        this.selectedPos = null;
        BlockRayTraceResult trace = RaycastHelper.rayTraceRange(player.field_70170_p, (PlayerEntity)player, 75.0);
        if (trace == null || trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos hit = new BlockPos(trace.func_216347_e());
        boolean replaceable = player.field_70170_p.func_180495_p(hit).func_185904_a().func_76222_j();
        if (trace.func_216354_b().func_176740_k().func_200128_b() && !replaceable) {
            hit = hit.func_177972_a(trace.func_216354_b());
        }
        this.selectedPos = hit;
        if (snap) {
            this.lastChasingSelectedPos = this.chasingSelectedPos = Vector3d.func_237491_b_((Vector3i)this.selectedPos);
        }
    }

    @Override
    public void renderTool(MatrixStack ms, SuperRenderTypeBuffer buffer) {
    }

    @Override
    public void renderOverlay(MatrixStack ms, IRenderTypeBuffer buffer) {
    }

    @Override
    public void renderOnSchematic(MatrixStack ms, SuperRenderTypeBuffer buffer) {
        if (!this.schematicHandler.isDeployed()) {
            return;
        }
        ms.func_227860_a_();
        AABBOutline outline = this.schematicHandler.getOutline();
        if (this.renderSelectedFace) {
            outline.getParams().highlightFace(this.selectedFace).withFaceTextures(AllSpecialTextures.CHECKERED, AllKeys.ctrlDown() ? AllSpecialTextures.HIGHLIGHT_CHECKERED : AllSpecialTextures.CHECKERED);
        }
        outline.getParams().colored(6850245).withFaceTexture(AllSpecialTextures.CHECKERED).lineWidth(0.0625f);
        outline.render(ms, buffer, AnimationTickHolder.getPartialTicks());
        outline.getParams().clearTextures();
        ms.func_227865_b_();
    }
}

