/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.events;

import com.mojang.brigadier.CommandDispatcher;
import com.simibubi.create.AllFluids;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingPhysics;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.fluids.recipe.FluidTransferRecipes;
import com.simibubi.create.content.contraptions.fluids.recipe.PotionMixingRecipeManager;
import com.simibubi.create.content.contraptions.wrench.WrenchItem;
import com.simibubi.create.content.curiosities.zapper.ZapperInteractionHandler;
import com.simibubi.create.content.curiosities.zapper.ZapperItem;
import com.simibubi.create.content.logistics.item.LinkedControllerServerHandler;
import com.simibubi.create.foundation.command.AllCommands;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.WorldAttached;
import com.simibubi.create.foundation.utility.recipe.RecipeFinder;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

@Mod.EventBusSubscriber
public class CommonEvents {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Create.SCHEMATIC_RECEIVER.tick();
        Create.LAGGER.tick();
        ServerSpeedProvider.serverTick();
    }

    @SubscribeEvent
    public static void onChunkUnloaded(ChunkEvent.Unload event) {
        CapabilityMinecartController.onChunkUnloaded(event);
    }

    @SubscribeEvent
    public static void whenFluidsMeet(BlockEvent.FluidPlaceBlockEvent event) {
        BlockState blockState = event.getOriginalState();
        FluidState fluidState = blockState.func_204520_s();
        BlockPos pos = event.getPos();
        IWorld world = event.getWorld();
        if (fluidState.func_206889_d() && FluidHelper.isLava(fluidState.func_206886_c())) {
            return;
        }
        for (Direction direction : Iterate.directions) {
            BlockState lavaInteraction;
            FluidState metFluidState;
            FluidState fluidState2 = metFluidState = fluidState.func_206889_d() ? fluidState : world.func_204610_c(pos.func_177972_a(direction));
            if (!metFluidState.func_206884_a((ITag)FluidTags.field_206959_a) || (lavaInteraction = AllFluids.getLavaInteraction(metFluidState)) == null) continue;
            event.setNewState(lavaInteraction);
            break;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        World world = event.world;
        ContraptionHandler.tick(world);
        CapabilityMinecartController.tick(world);
        CouplingPhysics.tick(world);
        LinkedControllerServerHandler.tick((IWorld)world);
    }

    @SubscribeEvent
    public static void onUpdateLivingEntity(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entityLiving = event.getEntityLiving();
        World world = entityLiving.field_70170_p;
        if (world == null) {
            return;
        }
        ContraptionHandler.entitiesWhoJustDismountedGetSentToTheRightLocation(entityLiving, world);
    }

    @SubscribeEvent
    public static void onEntityAdded(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = event.getWorld();
        ContraptionHandler.addSpawnedContraptionsToCollisionList(entity, world);
    }

    @SubscribeEvent
    public static void onEntityAttackedByPlayer(AttackEntityEvent event) {
        WrenchItem.wrenchInstaKillsMinecarts(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerCommands(RegisterCommandsEvent event) {
        AllCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)RecipeFinder.LISTENER);
        event.addListener((IFutureReloadListener)PotionMixingRecipeManager.LISTENER);
        event.addListener((IFutureReloadListener)FluidTransferRecipes.LISTENER);
    }

    @SubscribeEvent
    public static void serverStopped(FMLServerStoppingEvent event) {
        Create.SCHEMATIC_RECEIVER.shutdown();
    }

    @SubscribeEvent
    public static void onLoadWorld(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        Create.REDSTONE_LINK_NETWORK_HANDLER.onLoadWorld(world);
        Create.TORQUE_PROPAGATOR.onLoadWorld(world);
    }

    @SubscribeEvent
    public static void onUnloadWorld(WorldEvent.Unload event) {
        IWorld world = event.getWorld();
        Create.REDSTONE_LINK_NETWORK_HANDLER.onUnloadWorld(world);
        Create.TORQUE_PROPAGATOR.onUnloadWorld(world);
        WorldAttached.invalidateWorld(world);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        CapabilityMinecartController.attach(event);
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        CapabilityMinecartController.startTracking(event);
    }

    public static void leftClickEmpty(ServerPlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ZapperItem) {
            ZapperInteractionHandler.trySelect(stack, (PlayerEntity)player);
        }
    }
}

