/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Couple;
import java.awt.Color;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class BoxElement
extends RenderElement {
    protected Color background = new Color(-16777216, true);
    protected Color borderTop = new Color(1090514653, true);
    protected Color borderBot = new Color(553643741, true);
    protected int borderOffset = 2;

    public <T extends BoxElement> T withBackground(Color color) {
        this.background = color;
        return (T)this;
    }

    public <T extends BoxElement> T withBackground(int color) {
        return this.withBackground(new Color(color, true));
    }

    public <T extends BoxElement> T flatBorder(Color color) {
        this.borderTop = color;
        this.borderBot = color;
        return (T)this;
    }

    public <T extends BoxElement> T flatBorder(int color) {
        return this.flatBorder(new Color(color, true));
    }

    public <T extends BoxElement> T gradientBorder(Couple<Color> colors) {
        this.borderTop = (Color)colors.getFirst();
        this.borderBot = (Color)colors.getSecond();
        return (T)this;
    }

    public <T extends BoxElement> T gradientBorder(Color top, Color bot) {
        this.borderTop = top;
        this.borderBot = bot;
        return (T)this;
    }

    public <T extends BoxElement> T gradientBorder(int top, int bot) {
        return this.gradientBorder(new Color(top, true), new Color(bot, true));
    }

    public <T extends BoxElement> T withBorderOffset(int offset) {
        this.borderOffset = offset;
        return (T)this;
    }

    @Override
    public void render(MatrixStack ms) {
        this.renderBox(ms);
    }

    protected void renderBox(MatrixStack ms) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        int f = this.borderOffset;
        Color c1 = ColorHelper.applyAlpha(this.background, this.alpha);
        Color c2 = ColorHelper.applyAlpha(this.borderTop, this.alpha);
        Color c3 = ColorHelper.applyAlpha(this.borderBot, this.alpha);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder b = tessellator.func_178180_c();
        Matrix4f model = ms.func_227866_c_().func_227870_a_();
        b.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y - (float)f - 2.0f, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y - (float)f - 1.0f, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f - 1.0f, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f - 2.0f, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 2.0f, this.y - (float)f - 1.0f, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 2.0f, this.y + (float)f + 1.0f + (float)this.height, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y + (float)f + 1.0f + (float)this.height, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y - (float)f - 1.0f, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y + (float)f + 1.0f + (float)this.height, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y + (float)f + 2.0f + (float)this.height, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + 2.0f + (float)this.height, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + 1.0f + (float)this.height, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f - 1.0f, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + 1.0f + (float)this.height, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 2.0f + (float)this.width, this.y + (float)f + 1.0f + (float)this.height, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 2.0f + (float)this.width, this.y - (float)f - 1.0f, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y - (float)f - 1.0f, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y + (float)f + 1.0f + (float)this.height, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + 1.0f + (float)this.height, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f - 1.0f, this.z).func_225586_a_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).func_181675_d();
        tessellator.func_78381_a();
        b.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y - (float)f - 1.0f, this.z).func_225586_a_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y - (float)f, this.z).func_225586_a_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f, this.z).func_225586_a_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f - 1.0f, this.z).func_225586_a_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y - (float)f, this.z).func_225586_a_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y + (float)f + (float)this.height, this.z).func_225586_a_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f, this.y + (float)f + (float)this.height, this.z).func_225586_a_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f, this.y - (float)f, this.z).func_225586_a_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y + (float)f + (float)this.height, this.z).func_225586_a_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x - (float)f - 1.0f, this.y + (float)f + 1.0f + (float)this.height, this.z).func_225586_a_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + 1.0f + (float)this.height, this.z).func_225586_a_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + (float)this.height, this.z).func_225586_a_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + (float)this.width, this.y - (float)f, this.z).func_225586_a_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + (float)this.width, this.y + (float)f + (float)this.height, this.z).func_225586_a_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + (float)this.height, this.z).func_225586_a_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).func_181675_d();
        b.func_227888_a_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f, this.z).func_225586_a_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }
}

