/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.simibubi.create.foundation.utility.Couple;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Theme {
    private static final Theme base = new Theme();
    private static Theme custom = null;
    protected final Map<String, ColorHolder> colors = new HashMap<String, ColorHolder>();

    public static void setTheme(@Nullable Theme theme) {
        custom = theme;
    }

    public static void reload() {
        base.init();
        if (custom != null) {
            custom.init();
        }
    }

    private static ColorHolder resolve(String key) {
        ColorHolder h = null;
        if (custom != null) {
            h = custom.get(key);
        }
        if (h == null) {
            h = base.get(key);
        }
        if (h == null) {
            h = ColorHolder.missing;
        }
        return h;
    }

    @Nonnull
    public static Couple<Color> p(@Nonnull Key key) {
        return Theme.p(key.get());
    }

    @Nonnull
    public static Couple<Color> p(String key) {
        return Theme.resolve(key).asPair();
    }

    @Nonnull
    public static Color c(@Nonnull Key key, boolean first) {
        return Theme.c(key.get(), first);
    }

    @Nonnull
    public static Color c(String key, boolean first) {
        return Theme.p(key).get(first);
    }

    public static int i(@Nonnull Key key, boolean first) {
        return Theme.i(key.get(), first);
    }

    public static int i(String key, boolean first) {
        return Theme.p(key).get(first).getRGB();
    }

    @Nonnull
    public static Color c(@Nonnull Key key) {
        return Theme.c(key.get());
    }

    @Nonnull
    public static Color c(String key) {
        return Theme.resolve(key).get();
    }

    public static int i(@Nonnull Key key) {
        return Theme.i(key.get());
    }

    public static int i(String key) {
        return Theme.resolve(key).get().getRGB();
    }

    protected Theme() {
        this.init();
    }

    protected void init() {
        this.put(Key.BUTTON_IDLE, new Color(-578111786, true), new Color(-1869957418, true));
        this.put(Key.BUTTON_HOVER, new Color(-6636589, true), new Color(-795165741, true));
        this.put(Key.BUTTON_CLICK, new Color(-1), new Color(-285212673));
        this.put(Key.BUTTON_DISABLE, new Color(-2138009456, true), new Color(0x60909090, true));
        this.put(Key.BUTTON_SUCCESS, new Color(-863438968, true), new Color(-870265824, true));
        this.put(Key.BUTTON_FAIL, new Color(-856192888, true), new Color(-859037664, true));
        this.put(Key.TEXT, new Color(-1118482), new Color(-6052957));
        this.put(Key.TEXT_DARKER, new Color(-6052957), new Color(-8355712));
        this.put(Key.TEXT_ACCENT_STRONG, new Color(-7686442), new Color(-7686442));
        this.put(Key.TEXT_ACCENT_SLIGHT, new Color(-2232577), new Color(-6246208));
        this.put(Key.STREAK, new Color(0x101010, false));
        this.put(Key.PONDER_BUTTON_IDLE, new Color(1623245055, true), new Color(817938687, true));
        this.put(Key.PONDER_BUTTON_HOVER, new Color(-255803137, true), new Color(-1597980417, true));
        this.put(Key.PONDER_BUTTON_CLICK, new Color(-1), new Color(-570425345));
        this.put(Key.PONDER_BUTTON_DISABLE, new Color(-2138009456, true), new Color(0x20909090, true));
        this.put(Key.PONDER_BACKGROUND_TRANSPARENT, new Color(-587202560, true));
        this.put(Key.PONDER_BACKGROUND_FLAT, new Color(-16777216, false));
        this.put(Key.PONDER_IDLE, new Color(1090514653, true), new Color(553643741, true));
        this.put(Key.PONDER_HOVER, new Color(0x70FFFFFF, true), new Color(0x30FFFFFF, true));
        this.put(Key.PONDER_HIGHLIGHT, new Color(-251662627, true), new Color(1627385565, true));
        this.put(Key.TEXT_WINDOW_BORDER, new Color(1618632704, true), new Color(544890880, true));
        this.put(Key.PONDER_BACK_ARROW, new Color(-257255015, true), new Color(816486809, true));
        this.put(Key.PONDER_PROGRESSBAR, new Color(-2130710819, true), new Color(1358950109, true));
        this.put(Key.PONDER_MISSING_CREATE, new Color(1889027328, true), new Color(1885938688, true));
        this.put(Key.PONDER_MISSING_VANILLA, new Color(0x505000FF, true), new Color(1345323127, true));
        this.put(Key.CONFIG_TITLE_A, new Color(-3760196, true), new Color(-608069, true));
        this.put(Key.CONFIG_TITLE_B, new Color(-608069, true), new Color(-263788, true));
    }

    protected void put(String key, Color c) {
        this.colors.put(key, ColorHolder.single(c));
    }

    protected void put(Key key, Color c) {
        this.put(key.get(), c);
    }

    protected void put(String key, Color c1, Color c2) {
        this.colors.put(key, ColorHolder.pair(c1, c2));
    }

    protected void put(Key key, Color c1, Color c2) {
        this.put(key.get(), c1, c2);
    }

    @Nullable
    protected ColorHolder get(String key) {
        return this.colors.get(key);
    }

    private static class ColorHolder {
        private static final ColorHolder missing = ColorHolder.single(Color.BLACK);
        private Couple<Color> colors;

        private ColorHolder() {
        }

        private static ColorHolder single(Color c) {
            ColorHolder h = new ColorHolder();
            h.colors = Couple.create(c, c);
            return h;
        }

        private static ColorHolder pair(Color first, Color second) {
            ColorHolder h = new ColorHolder();
            h.colors = Couple.create(first, second);
            return h;
        }

        private Color get() {
            return (Color)this.colors.getFirst();
        }

        private Couple<Color> asPair() {
            return this.colors;
        }
    }

    public static class Key {
        public static Key BUTTON_IDLE = new Key();
        public static Key BUTTON_HOVER = new Key();
        public static Key BUTTON_CLICK = new Key();
        public static Key BUTTON_DISABLE = new Key();
        public static Key BUTTON_SUCCESS = new Key();
        public static Key BUTTON_FAIL = new Key();
        public static Key TEXT = new Key();
        public static Key TEXT_DARKER = new Key();
        public static Key TEXT_ACCENT_STRONG = new Key();
        public static Key TEXT_ACCENT_SLIGHT = new Key();
        public static Key STREAK = new Key();
        public static Key PONDER_BACKGROUND_TRANSPARENT = new Key();
        public static Key PONDER_BACKGROUND_FLAT = new Key();
        public static Key PONDER_IDLE = new Key();
        public static Key PONDER_HOVER = new Key();
        public static Key PONDER_HIGHLIGHT = new Key();
        public static Key TEXT_WINDOW_BORDER = new Key();
        public static Key PONDER_BACK_ARROW = new Key();
        public static Key PONDER_PROGRESSBAR = new Key();
        public static Key PONDER_MISSING_CREATE = new Key();
        public static Key PONDER_MISSING_VANILLA = new Key();
        public static Key PONDER_BUTTON_IDLE = new Key();
        public static Key PONDER_BUTTON_HOVER = new Key();
        public static Key PONDER_BUTTON_CLICK = new Key();
        public static Key PONDER_BUTTON_DISABLE = new Key();
        public static Key CONFIG_TITLE_A = new Key();
        public static Key CONFIG_TITLE_B = new Key();
        private static int index = 0;
        private final String s;

        protected Key() {
            this.s = "_" + index++;
        }

        protected Key(String s) {
            this.s = s;
        }

        public String get() {
            return this.s;
        }
    }
}

