/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.BakedModelWrapper;

public abstract class CustomRenderedItemModel
extends BakedModelWrapper<IBakedModel> {
    protected String basePath;
    protected Map<String, IBakedModel> partials = new HashMap<String, IBakedModel>();
    protected ItemStackTileEntityRenderer renderer;

    public CustomRenderedItemModel(IBakedModel template, String basePath) {
        super(template);
        this.basePath = basePath;
        this.renderer = this.createRenderer();
    }

    public boolean func_188618_c() {
        return true;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        super.handlePerspective(cameraTransformType, mat);
        return this;
    }

    public final IBakedModel getOriginalModel() {
        return this.originalModel;
    }

    public ItemStackTileEntityRenderer getRenderer() {
        return this.renderer;
    }

    public abstract ItemStackTileEntityRenderer createRenderer();

    public final List<ResourceLocation> getModelLocations() {
        return this.partials.keySet().stream().map(this::getPartialModelLocation).collect(Collectors.toList());
    }

    protected void addPartials(String ... partials) {
        this.partials.clear();
        for (String name : partials) {
            this.partials.put(name, null);
        }
    }

    public CustomRenderedItemModel loadPartials(ModelBakeEvent event) {
        for (String name : this.partials.keySet()) {
            this.partials.put(name, this.loadModel(event, name));
        }
        return this;
    }

    private IBakedModel loadModel(ModelBakeEvent event, String name) {
        return event.getModelLoader().func_217845_a(this.getPartialModelLocation(name), (IModelTransform)ModelRotation.X0_Y0);
    }

    private ResourceLocation getPartialModelLocation(String name) {
        return new ResourceLocation("create", "item/" + this.basePath + "/" + name);
    }

    public IBakedModel getPartial(String name) {
        return this.partials.get(name);
    }
}

