/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.networking;

import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public interface ISyncPersistentData {
    public void onPersistentDataUpdated();

    default public void syncPersistentDataWithTracking(Entity self) {
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> self), (Object)new Packet(self));
    }

    public static class Packet
    extends SimplePacketBase {
        private int entityId;
        private Entity entity;
        private CompoundNBT readData;

        public Packet(Entity entity) {
            this.entity = entity;
            this.entityId = entity.func_145782_y();
        }

        public Packet(PacketBuffer buffer) {
            this.entityId = buffer.readInt();
            this.readData = buffer.func_150793_b();
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeInt(this.entityId);
            buffer.func_150786_a(this.entity.getPersistentData());
        }

        @Override
        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity entityByID = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
                if (!(entityByID instanceof ISyncPersistentData)) {
                    return;
                }
                CompoundNBT data = entityByID.getPersistentData();
                Iterator iterator = data.func_150296_c().iterator();
                while (iterator.hasNext()) {
                    data.func_82580_o((String)iterator.next());
                }
                data.func_197643_a(this.readData);
                ((ISyncPersistentData)entityByID).onPersistentDataUpdated();
            });
            context.get().setPacketHandled(true);
        }
    }
}

