/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.content.PonderTagIndexScreen;
import com.simibubi.create.foundation.ponder.content.PonderTagScreen;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class NavigatableSimiScreen
extends AbstractSimiScreen {
    public static final String THINK_BACK = "ponder.think_back";
    protected int depthPointX;
    protected int depthPointY;
    public final LerpedFloat transition = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.LINEAR);
    protected final LerpedFloat arrowAnimation = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.075f, LerpedFloat.Chaser.LINEAR);
    protected PonderButton backTrack;

    public NavigatableSimiScreen() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.depthPointX = window.func_198107_o() / 2;
        this.depthPointY = window.func_198087_p() / 2;
    }

    public void func_231175_as__() {
        ScreenOpener.clearStack();
        super.func_231175_as__();
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.transition.tickChaser();
        this.arrowAnimation.tickChaser();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.backTrack = null;
        List<Screen> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty()) {
            return;
        }
        if (!(screenHistory.get(0) instanceof NavigatableSimiScreen)) {
            return;
        }
        Screen screen = screenHistory.get(0);
        PonderTag icon = null;
        ItemStack altIcon = null;
        if (screen instanceof PonderTagIndexScreen) {
            altIcon = AllItems.WRENCH.asStack();
        }
        if (screen instanceof PonderUI) {
            altIcon = ((PonderUI)screen).stack;
        }
        if (screen instanceof PonderTagScreen) {
            icon = ((PonderTagScreen)screen).getTag();
        }
        this.backTrack = (PonderButton)((Object)((AbstractSimiWidget)((Object)new PonderButton(31, this.field_230709_l_ - 31 - 20).enableFade(0, 5))).withCallback(() -> ScreenOpener.openPreviousScreen(this, Optional.empty())));
        this.widgets.add(this.backTrack);
        this.backTrack.fade(1.0f);
        if (icon != null) {
            this.backTrack.showing(icon);
        }
        if (altIcon != null) {
            this.backTrack.showing(altIcon);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        if (this.backTrack == null) {
            return;
        }
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, 500.0);
        if (this.backTrack.func_230449_g_()) {
            TranslationTextComponent translate = Lang.translate(this.backTrackingLangKey(), new Object[0]);
            this.field_230712_o_.func_243248_b(ms, (ITextComponent)translate, (float)(41 - this.field_230712_o_.func_238414_a_((ITextProperties)translate) / 2), (float)(this.field_230709_l_ - 16), Theme.i(Theme.Key.TEXT_DARKER));
            if (MathHelper.func_180185_a((float)this.arrowAnimation.getValue(), (float)this.arrowAnimation.getChaseTarget())) {
                this.arrowAnimation.setValue(1.0);
                this.arrowAnimation.setValue(1.0);
            }
        }
        ms.func_227865_b_();
    }

    protected String backTrackingLangKey() {
        return THINK_BACK;
    }

    @Override
    protected void renderWindowBackground(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.backTrack != null) {
            int x = (int)MathHelper.func_219799_g((float)this.arrowAnimation.getValue(partialTicks), (float)-9.0f, (float)21.0f);
            int maxX = this.backTrack.field_230690_l_ + this.backTrack.func_230998_h_();
            if (x + 30 < this.backTrack.field_230690_l_) {
                UIRenderHelper.breadcrumbArrow(ms, x + 30, this.field_230709_l_ - 51, 0, maxX - (x + 30), 20, 5, Theme.p(Theme.Key.PONDER_BACK_ARROW));
            }
            UIRenderHelper.breadcrumbArrow(ms, x, this.field_230709_l_ - 51, 0, 30, 20, 5, Theme.p(Theme.Key.PONDER_BACK_ARROW));
            UIRenderHelper.breadcrumbArrow(ms, x - 30, this.field_230709_l_ - 51, 0, 30, 20, 5, Theme.p(Theme.Key.PONDER_BACK_ARROW));
        }
        if (this.transition.getChaseTarget() == 0.0f || this.transition.settled()) {
            this.func_230446_a_(ms);
            return;
        }
        this.func_230446_a_(ms);
        Screen lastScreen = ScreenOpener.getPreviouslyRenderedScreen();
        float transitionValue = this.transition.getValue(partialTicks);
        float scale = 1.0f + 0.5f * transitionValue;
        if (lastScreen != null && lastScreen != this && !this.transition.settled()) {
            ms.func_227860_a_();
            UIRenderHelper.framebuffer.func_216493_b(Minecraft.field_142025_a);
            ms.func_227861_a_(0.0, 0.0, -1000.0);
            UIRenderHelper.framebuffer.func_147610_a(true);
            lastScreen.func_230430_a_(ms, mouseX, mouseY, partialTicks);
            ms.func_227865_b_();
            ms.func_227860_a_();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            int dpx = window.func_198107_o() / 2;
            int dpy = window.func_198087_p() / 2;
            if (lastScreen instanceof AbstractSimiScreen) {
                dpx = ((NavigatableSimiScreen)lastScreen).depthPointX;
                dpy = ((NavigatableSimiScreen)lastScreen).depthPointY;
            }
            ms.func_227861_a_((double)dpx, (double)dpy, 0.0);
            ms.func_227862_a_(scale, scale, 1.0f);
            ms.func_227861_a_((double)(-dpx), (double)(-dpy), 0.0);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableAlphaTest();
            UIRenderHelper.drawFramebuffer(1.0f - Math.abs(transitionValue));
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            ms.func_227865_b_();
        }
        scale = transitionValue > 0.0f ? 1.0f - 0.5f * (1.0f - transitionValue) : 1.0f + 0.5f * (1.0f + transitionValue);
        ms.func_227861_a_((double)this.depthPointX, (double)this.depthPointY, 0.0);
        ms.func_227862_a_(scale, scale, 1.0f);
        ms.func_227861_a_((double)(-this.depthPointX), (double)(-this.depthPointY), 0.0);
    }

    @Override
    public boolean func_231046_a_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (code == 259) {
            ScreenOpener.openPreviousScreen(this, Optional.empty());
            return true;
        }
        return super.func_231046_a_(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void centerScalingOn(int x, int y) {
        this.depthPointX = x;
        this.depthPointY = y;
    }

    public void centerScalingOnMouse() {
        MainWindow w = this.field_230706_i_.func_228018_at_();
        double mouseX = this.field_230706_i_.field_71417_B.func_198024_e() * (double)w.func_198107_o() / (double)w.func_198105_m();
        double mouseY = this.field_230706_i_.field_71417_B.func_198026_f() * (double)w.func_198087_p() / (double)w.func_198083_n();
        this.centerScalingOn((int)mouseX, (int)mouseY);
    }

    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return false;
    }

    public void shareContextWith(NavigatableSimiScreen other) {
    }

    protected void renderZeloBreadcrumbs(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        List<Screen> history = ScreenOpener.getScreenHistory();
        if (history.isEmpty()) {
            return;
        }
        history.add(0, Minecraft.func_71410_x().field_71462_r);
        int spacing = 20;
        List<String> names = history.stream().map(NavigatableSimiScreen::screenTitle).collect(Collectors.toList());
        int bWidth = names.stream().mapToInt(s -> this.field_230712_o_.func_78256_a(s) + spacing).sum();
        MutableInt x = new MutableInt(this.field_230708_k_ - bWidth);
        MutableInt y = new MutableInt(this.field_230709_l_ - 18);
        MutableBoolean first = new MutableBoolean(true);
        if (x.getValue() < 25) {
            x.setValue(25);
        }
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, 600.0);
        names.forEach(s -> {
            int sWidth = this.field_230712_o_.func_78256_a(s);
            UIRenderHelper.breadcrumbArrow(ms, x.getValue(), y.getValue(), 0, sWidth + spacing, 14, spacing / 2, -586149872, 0x44101010);
            this.field_230712_o_.func_238421_b_(ms, s, (float)(x.getValue() + 5), (float)(y.getValue() + 3), first.getValue() != false ? -1114130 : -2232577);
            first.setFalse();
            x.add(sWidth + spacing);
        });
        ms.func_227865_b_();
    }

    private static String screenTitle(Screen screen) {
        if (screen instanceof NavigatableSimiScreen) {
            return ((NavigatableSimiScreen)screen).getBreadcrumbTitle();
        }
        return "<";
    }

    protected String getBreadcrumbTitle() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

