/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.BoxElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class PonderProgressBar
extends AbstractSimiWidget {
    LerpedFloat progress;
    PonderUI ponder;

    public PonderProgressBar(PonderUI ponder, int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.ponder = ponder;
        this.progress = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void tick() {
        this.progress.chase(this.ponder.getActiveScene().getSceneProgress(), 0.5, LerpedFloat.Chaser.EXP);
        this.progress.tickChaser();
    }

    @Override
    protected boolean func_230992_c_(double mouseX, double mouseY) {
        return this.field_230693_o_ && this.field_230694_p_ && !this.ponder.getActiveScene().keyframeTimes.isEmpty() && mouseX >= (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_ + 4) && mouseY >= (double)this.field_230691_m_ - 3.0 && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_ + 20);
    }

    @Override
    public void func_230982_a_(double mouseX, double mouseY) {
        PonderScene activeScene = this.ponder.getActiveScene();
        IntList keyframeTimes = activeScene.keyframeTimes;
        int keyframeIndex = this.getHoveredKeyframeIndex(activeScene, mouseX);
        if (keyframeIndex == -1) {
            this.ponder.seekToTime(0);
        } else if (keyframeIndex == keyframeTimes.size()) {
            this.ponder.seekToTime(activeScene.totalTime);
        } else {
            this.ponder.seekToTime(keyframeTimes.getInt(keyframeIndex));
        }
    }

    public int getHoveredKeyframeIndex(PonderScene activeScene, double mouseX) {
        int keyframeTime;
        IntList keyframeTimes = activeScene.keyframeTimes;
        int totalTime = activeScene.totalTime;
        int clickedAtTime = (int)((mouseX - (double)this.field_230690_l_) / ((double)this.field_230688_j_ + 4.0) * (double)totalTime);
        int lastKeyframeTime = keyframeTimes.getInt(keyframeTimes.size() - 1);
        int diffToEnd = totalTime - clickedAtTime;
        int diffToLast = clickedAtTime - lastKeyframeTime;
        if (diffToEnd > 0 && diffToEnd < diffToLast / 2) {
            return keyframeTimes.size();
        }
        int index = -1;
        int i = 0;
        while (i < keyframeTimes.size() && (keyframeTime = keyframeTimes.getInt(i)) <= clickedAtTime) {
            index = i++;
        }
        return index;
    }

    @Override
    public void func_230431_b_(@Nonnull MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.field_230692_n_ = this.func_230992_c_(mouseX, mouseY);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(this.field_230690_l_, this.field_230691_m_, 300.0f)).withBounds(this.field_230688_j_, this.field_230689_k_)).render(ms);
        ms.func_227860_a_();
        ms.func_227861_a_((double)(this.field_230690_l_ - 2), (double)(this.field_230691_m_ - 2), 200.0);
        ms.func_227860_a_();
        ms.func_227862_a_((float)(this.field_230688_j_ + 4) * this.progress.getValue(partialTicks), 1.0f, 1.0f);
        int c1 = Theme.i(Theme.Key.PONDER_PROGRESSBAR, true);
        int c2 = Theme.i(Theme.Key.PONDER_PROGRESSBAR, false);
        GuiUtils.drawGradientRect((Matrix4f)ms.func_227866_c_().func_227870_a_(), (int)110, (int)0, (int)3, (int)1, (int)4, (int)c1, (int)c1);
        GuiUtils.drawGradientRect((Matrix4f)ms.func_227866_c_().func_227870_a_(), (int)110, (int)0, (int)4, (int)1, (int)5, (int)c2, (int)c2);
        ms.func_227865_b_();
        this.renderKeyframes(ms, mouseX, partialTicks);
        ms.func_227865_b_();
    }

    private void renderKeyframes(MatrixStack ms, int mouseX, float partialTicks) {
        PonderScene activeScene = this.ponder.getActiveScene();
        int hoverStartColor = Theme.i(Theme.Key.PONDER_HOVER, true) | 0xA0000000;
        int hoverEndColor = Theme.i(Theme.Key.PONDER_HOVER, false) | 0xA0000000;
        int idleStartColor = Theme.i(Theme.Key.PONDER_IDLE, true) | 0x40000000;
        int idleEndColor = Theme.i(Theme.Key.PONDER_IDLE, false) | 0x40000000;
        int hoverIndex = this.field_230692_n_ ? this.getHoveredKeyframeIndex(activeScene, mouseX) : -2;
        IntList keyframeTimes = activeScene.keyframeTimes;
        if (hoverIndex == -1) {
            this.drawKeyframe(ms, activeScene, true, 0, 0, hoverStartColor, hoverEndColor, 8);
        } else if (hoverIndex == keyframeTimes.size()) {
            this.drawKeyframe(ms, activeScene, true, activeScene.totalTime, this.field_230688_j_ + 4, hoverStartColor, hoverEndColor, 8);
        }
        for (int i = 0; i < keyframeTimes.size(); ++i) {
            int keyframeTime = keyframeTimes.getInt(i);
            int keyframePos = (int)((float)keyframeTime / (float)activeScene.totalTime * (float)(this.field_230688_j_ + 4));
            boolean selected = i == hoverIndex;
            int startColor = selected ? hoverStartColor : idleStartColor;
            int endColor = selected ? hoverEndColor : idleEndColor;
            int height = selected ? 8 : 4;
            this.drawKeyframe(ms, activeScene, selected, keyframeTime, keyframePos, startColor, endColor, height);
        }
    }

    private void drawKeyframe(MatrixStack ms, PonderScene activeScene, boolean selected, int keyframeTime, int keyframePos, int startColor, int endColor, int height) {
        if (selected) {
            int offset;
            String text;
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            GuiUtils.drawGradientRect((Matrix4f)ms.func_227866_c_().func_227870_a_(), (int)100, (int)keyframePos, (int)10, (int)(keyframePos + 1), (int)(10 + height), (int)endColor, (int)startColor);
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, 0.0, 100.0);
            if (activeScene.currentTime < keyframeTime) {
                text = ">";
                offset = -1 - font.func_78256_a(text);
            } else {
                text = "<";
                offset = 3;
            }
            font.func_238421_b_(ms, text, (float)(keyframePos + offset), 10.0f, endColor);
            ms.func_227865_b_();
        }
        GuiUtils.drawGradientRect((Matrix4f)ms.func_227866_c_().func_227870_a_(), (int)500, (int)keyframePos, (int)-1, (int)(keyframePos + 1), (int)(2 + height), (int)startColor, (int)endColor);
    }

    public void func_230988_a_(SoundHandler handler) {
    }
}

