/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.elements.AnimatedSceneElement;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import java.util.function.Supplier;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ParrotElement
extends AnimatedSceneElement {
    private Vector3d location;
    private ParrotEntity entity;
    private ParrotPose pose;
    private Supplier<? extends ParrotPose> initialPose;

    public static ParrotElement create(Vector3d location, Supplier<? extends ParrotPose> pose) {
        return new ParrotElement(location, pose);
    }

    protected ParrotElement(Vector3d location, Supplier<? extends ParrotPose> pose) {
        this.location = location;
        this.initialPose = pose;
        this.setPose(this.initialPose.get());
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.setPose(this.initialPose.get());
        this.entity.func_226288_n_(0.0, 0.0, 0.0);
        this.entity.field_70169_q = 0.0;
        this.entity.field_70167_r = 0.0;
        this.entity.field_70166_s = 0.0;
        this.entity.field_70142_S = 0.0;
        this.entity.field_70137_T = 0.0;
        this.entity.field_70136_U = 0.0;
        this.entity.field_70125_A = 0.0f;
        this.entity.field_70127_C = 0.0f;
        this.entity.field_70177_z = 180.0f;
        this.entity.field_70126_B = 180.0f;
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.entity == null) {
            this.entity = this.pose.create(scene.getWorld());
            this.entity.field_70177_z = 180.0f;
            this.entity.field_70126_B = 180.0f;
        }
        ++this.entity.field_70173_aa;
        this.entity.field_70758_at = this.entity.field_70759_as;
        this.entity.field_192010_bD = this.entity.field_192009_bC;
        this.entity.field_192011_bE = this.entity.field_192008_bB;
        this.entity.field_70122_E = true;
        this.entity.field_70169_q = this.entity.func_226277_ct_();
        this.entity.field_70167_r = this.entity.func_226278_cu_();
        this.entity.field_70166_s = this.entity.func_226281_cx_();
        this.entity.field_70126_B = this.entity.field_70177_z;
        this.entity.field_70127_C = this.entity.field_70125_A;
        this.pose.tick(scene, this.entity, this.location);
        this.entity.field_70142_S = this.entity.func_226277_ct_();
        this.entity.field_70137_T = this.entity.func_226278_cu_();
        this.entity.field_70136_U = this.entity.func_226281_cx_();
    }

    public void setPositionOffset(Vector3d position, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        if (!immediate) {
            return;
        }
        this.entity.field_70169_q = position.field_72450_a;
        this.entity.field_70167_r = position.field_72448_b;
        this.entity.field_70166_s = position.field_72449_c;
    }

    public void setRotation(Vector3d eulers, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.field_70125_A = (float)eulers.field_72450_a;
        this.entity.field_70177_z = (float)eulers.field_72448_b;
        if (!immediate) {
            return;
        }
        this.entity.field_70127_C = this.entity.field_70125_A;
        this.entity.field_70126_B = this.entity.field_70177_z;
    }

    public Vector3d getPositionOffset() {
        return this.entity != null ? this.entity.func_213303_ch() : Vector3d.field_186680_a;
    }

    public Vector3d getRotation() {
        return this.entity != null ? new Vector3d((double)this.entity.field_70125_A, (double)this.entity.field_70177_z, 0.0) : Vector3d.field_186680_a;
    }

    @Override
    protected void renderLast(PonderWorld world, IRenderTypeBuffer buffer, MatrixStack ms, float fade, float pt) {
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        if (this.entity == null) {
            this.entity = this.pose.create(world);
            this.entity.field_70177_z = 180.0f;
            this.entity.field_70126_B = 180.0f;
        }
        ms.func_227860_a_();
        ms.func_227861_a_(this.location.field_72450_a, this.location.field_72448_b, this.location.field_72449_c);
        ms.func_227861_a_(MathHelper.func_219803_d((double)pt, (double)this.entity.field_70169_q, (double)this.entity.func_226277_ct_()), MathHelper.func_219803_d((double)pt, (double)this.entity.field_70167_r, (double)this.entity.func_226278_cu_()), MathHelper.func_219803_d((double)pt, (double)this.entity.field_70166_s, (double)this.entity.func_226281_cx_()));
        MatrixStacker.of(ms).rotateY(AngleHelper.angleLerp(pt, this.entity.field_70126_B, this.entity.field_70177_z));
        entityrenderermanager.func_229084_a_((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, pt, ms, buffer, this.lightCoordsFromFade(fade));
        ms.func_227865_b_();
    }

    public void setPose(ParrotPose pose) {
        this.pose = pose;
    }

    public static class FaceCursorPose
    extends FaceVecPose {
        @Override
        protected Vector3d getFacedVec(PonderScene scene) {
            Minecraft minecraft = Minecraft.func_71410_x();
            MainWindow w = minecraft.func_228018_at_();
            double mouseX = minecraft.field_71417_B.func_198024_e() * (double)w.func_198107_o() / (double)w.func_198105_m();
            double mouseY = minecraft.field_71417_B.func_198026_f() * (double)w.func_198087_p() / (double)w.func_198083_n();
            return scene.getTransform().screenToScene(mouseX, mouseY, 300, 0.0f);
        }
    }

    public static class FacePointOfInterestPose
    extends FaceVecPose {
        @Override
        protected Vector3d getFacedVec(PonderScene scene) {
            return scene.getPointOfInterest();
        }
    }

    public static abstract class FaceVecPose
    extends ParrotPose {
        @Override
        void tick(PonderScene scene, ParrotEntity entity, Vector3d location) {
            Vector3d p_200602_2_ = this.getFacedVec(scene);
            Vector3d Vector3d2 = location.func_178787_e(entity.func_174824_e(0.0f));
            double d0 = p_200602_2_.field_72450_a - Vector3d2.field_72450_a;
            double d1 = p_200602_2_.field_72448_b - Vector3d2.field_72448_b;
            double d2 = p_200602_2_.field_72449_c - Vector3d2.field_72449_c;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            float targetPitch = MathHelper.func_76142_g((float)((float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875))));
            float targetYaw = MathHelper.func_76142_g((float)((float)(-(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875)) + 90.0f));
            entity.field_70125_A = AngleHelper.angleLerp(0.4f, entity.field_70125_A, targetPitch);
            entity.field_70177_z = AngleHelper.angleLerp(0.4f, entity.field_70177_z, targetYaw);
        }

        protected abstract Vector3d getFacedVec(PonderScene var1);
    }

    public static class SpinOnComponentPose
    extends ParrotPose {
        private BlockPos componentPos;

        public SpinOnComponentPose(BlockPos componentPos) {
            this.componentPos = componentPos;
        }

        @Override
        void tick(PonderScene scene, ParrotEntity entity, Vector3d location) {
            TileEntity tileEntity = scene.getWorld().func_175625_s(this.componentPos);
            if (!(tileEntity instanceof KineticTileEntity)) {
                return;
            }
            float rpm = ((KineticTileEntity)tileEntity).getSpeed();
            entity.field_70126_B = entity.field_70177_z;
            entity.field_70177_z += rpm * 0.3f;
        }
    }

    public static class FlappyPose
    extends ParrotPose {
        @Override
        void tick(PonderScene scene, ParrotEntity entity, Vector3d location) {
            double length = entity.func_213303_ch().func_178786_a(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U).func_72433_c();
            entity.field_70122_E = false;
            double phase = Math.min(length * 15.0, 8.0);
            float f = (float)((double)(PonderUI.ponderTicks % 100) * phase);
            entity.field_192009_bC = MathHelper.func_76126_a((float)f) + 1.0f;
            if (length == 0.0) {
                entity.field_192009_bC = 0.0f;
            }
        }
    }

    public static class DancePose
    extends ParrotPose {
        @Override
        ParrotEntity create(PonderWorld world) {
            ParrotEntity entity = super.create(world);
            entity.func_191987_a(BlockPos.field_177992_a, true);
            return entity;
        }

        @Override
        void tick(PonderScene scene, ParrotEntity entity, Vector3d location) {
            entity.field_70126_B = entity.field_70177_z;
            entity.field_70177_z -= 2.0f;
        }
    }

    public static abstract class ParrotPose {
        abstract void tick(PonderScene var1, ParrotEntity var2, Vector3d var3);

        ParrotEntity create(PonderWorld world) {
            ParrotEntity entity = new ParrotEntity(EntityType.field_200783_W, (World)world);
            int nextInt = Create.RANDOM.nextInt(5);
            entity.func_191997_m(nextInt == 1 ? 0 : nextInt);
            return entity;
        }
    }
}

