/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.BoxElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.AnimatedOverlayElement;
import com.simibubi.create.foundation.utility.ColorHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class TextWindowElement
extends AnimatedOverlayElement {
    Supplier<String> textGetter = () -> "(?) No text was provided";
    String bakedText;
    int y;
    Vector3d vec;
    boolean nearScene = false;
    int color = PonderPalette.WHITE.getColor();

    @Override
    protected void render(PonderScene scene, PonderUI screen, MatrixStack ms, float partialTicks, float fade) {
        if (this.bakedText == null) {
            this.bakedText = this.textGetter.get();
        }
        if (fade < 0.0625f) {
            return;
        }
        Vector2f sceneToScreen = this.vec != null ? scene.getTransform().sceneToScreen(this.vec, partialTicks) : new Vector2f((float)(screen.field_230708_k_ / 2), (float)((screen.field_230709_l_ - 200) / 2 + this.y - 8));
        float yDiff = ((float)screen.field_230709_l_ / 2.0f - sceneToScreen.field_189983_j - 10.0f) / 100.0f;
        int targetX = (int)((float)screen.field_230708_k_ * MathHelper.func_219799_g((float)(yDiff * yDiff), (float)0.75f, (float)0.625f));
        if (this.nearScene) {
            targetX = (int)Math.min((float)targetX, sceneToScreen.field_189982_i + 50.0f);
        }
        int textWidth = Math.min(screen.field_230708_k_ - targetX, 180);
        List lines = screen.getFontRenderer().func_238420_b_().func_238365_g_(this.bakedText, textWidth, Style.field_240709_b_);
        int boxWidth = 0;
        for (ITextProperties line : lines) {
            boxWidth = Math.max(boxWidth, screen.getFontRenderer().func_238414_a_(line));
        }
        int boxHeight = screen.getFontRenderer().func_78267_b(this.bakedText, boxWidth);
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, (double)sceneToScreen.field_189983_j, 400.0);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.TEXT_WINDOW_BORDER))).at(targetX - 10, 3.0f, 100.0f)).withBounds(boxWidth, boxHeight - 1)).render(ms);
        int brighterColor = ColorHelper.mixAlphaColors(this.color, -35, 0.5f);
        if (this.vec != null) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)sceneToScreen.field_189982_i, 0.0, 0.0);
            double lineTarget = ((float)targetX - sceneToScreen.field_189982_i) * fade;
            ms.func_227862_a_((float)lineTarget, 1.0f, 1.0f);
            Matrix4f model = ms.func_227866_c_().func_227870_a_();
            GuiUtils.drawGradientRect((Matrix4f)model, (int)-100, (int)0, (int)0, (int)1, (int)1, (int)brighterColor, (int)brighterColor);
            GuiUtils.drawGradientRect((Matrix4f)model, (int)-100, (int)0, (int)1, (int)1, (int)2, (int)-11974327, (int)-13027015);
            ms.func_227865_b_();
        }
        ms.func_227861_a_(0.0, 0.0, 400.0);
        for (int i = 0; i < lines.size(); ++i) {
            screen.getFontRenderer().func_238421_b_(ms, ((ITextProperties)lines.get(i)).getString(), (float)(targetX - 10), (float)(3 + 9 * i), ColorHelper.applyAlpha(brighterColor, fade));
        }
        ms.func_227865_b_();
    }

    public int getColor() {
        return this.color;
    }

    public class Builder {
        private PonderScene scene;

        public Builder(PonderScene scene) {
            this.scene = scene;
        }

        public Builder colored(PonderPalette color) {
            TextWindowElement.this.color = color.getColor();
            return this;
        }

        public Builder pointAt(Vector3d vec) {
            TextWindowElement.this.vec = vec;
            return this;
        }

        public Builder independent(int y) {
            TextWindowElement.this.y = y;
            return this;
        }

        public Builder independent() {
            return this.independent(0);
        }

        public Builder text(String defaultText) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText);
            return this;
        }

        public Builder sharedText(String key) {
            TextWindowElement.this.textGetter = () -> PonderLocalization.getShared(key);
            return this;
        }

        public Builder placeNearTarget() {
            TextWindowElement.this.nearScene = true;
            return this;
        }

        public Builder attachKeyFrame() {
            this.scene.builder().addLazyKeyframe();
            return this;
        }
    }
}

