/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.widgets.BoxWidget;
import com.simibubi.create.foundation.gui.widgets.ElementWidget;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class PonderButton
extends BoxWidget {
    protected ItemStack item;
    protected PonderTag tag;
    protected KeyBinding shortcut;
    protected LerpedFloat flash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);

    public PonderButton(int x, int y) {
        this(x, y, 20, 20);
    }

    public PonderButton(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.z = 400.0f;
        this.paddingX = 2.0f;
        this.paddingY = 2.0f;
    }

    public <T extends PonderButton> T withShortcut(KeyBinding key) {
        this.shortcut = key;
        return (T)((Object)this);
    }

    public <T extends PonderButton> T showingTag(PonderTag tag) {
        this.tag = tag;
        return (T)((Object)((PonderButton)((Object)this.showing(this.tag))));
    }

    public <T extends PonderButton> T showing(ItemStack item) {
        this.item = item;
        return (T)((Object)((PonderButton)((Object)super.showingElement((RenderElement)GuiGameElement.of(item).scale(1.5).at(-4.0f, -4.0f)))));
    }

    @Override
    public <T extends ElementWidget> T showingElement(RenderElement element) {
        return super.showingElement(element);
    }

    public void flash() {
        this.flash.updateChaseTarget(1.0f);
    }

    public void dim() {
        this.flash.updateChaseTarget(0.0f);
    }

    @Override
    public void tick() {
        super.tick();
        this.flash.tickChaser();
    }

    @Override
    protected void beforeRender(@Nonnull MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(ms, mouseX, mouseY, partialTicks);
        float flashValue = this.flash.getValue(partialTicks);
        if (flashValue > 0.1f) {
            float sin = 0.5f + 0.5f * MathHelper.func_76126_a((float)(((float)AnimationTickHolder.getTicks(true) + partialTicks) / 5.0f));
            Color c1 = this.gradientColor1;
            Color c2 = this.gradientColor2;
            Color nc1 = new Color(255, 255, 255, MathHelper.func_76125_a((int)(c1.getAlpha() + 150), (int)0, (int)255));
            Color nc2 = new Color(155, 155, 155, MathHelper.func_76125_a((int)(c2.getAlpha() + 150), (int)0, (int)255));
            this.gradientColor1 = ColorHelper.mixColors(c1, nc1, sin *= flashValue);
            this.gradientColor2 = ColorHelper.mixColors(c2, nc2, sin);
        }
    }

    @Override
    public void func_230431_b_(@Nonnull MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.func_230431_b_(ms, mouseX, mouseY, partialTicks);
        float fadeValue = this.fade.getValue();
        if (fadeValue < 0.1f) {
            return;
        }
        if (this.shortcut != null) {
            ms.func_227861_a_(0.0, 0.0, (double)(this.z + 50.0f));
            PonderButton.func_238472_a_((MatrixStack)ms, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.shortcut.func_238171_j_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2 + 8), (int)(this.field_230691_m_ + this.field_230689_k_ - 6), (int)ColorHelper.applyAlpha(Theme.i(Theme.Key.TEXT_DARKER), fadeValue));
        }
    }

    public ItemStack getItem() {
        return this.item;
    }

    public PonderTag getTag() {
        return this.tag;
    }

    @Override
    public Theme.Key getDisabledTheme() {
        return Theme.Key.PONDER_BUTTON_DISABLE;
    }

    @Override
    public Theme.Key getIdleTheme() {
        return Theme.Key.PONDER_BUTTON_IDLE;
    }

    @Override
    public Theme.Key getHoverTheme() {
        return Theme.Key.PONDER_BUTTON_HOVER;
    }

    @Override
    public Theme.Key getClickTheme() {
        return Theme.Key.PONDER_BUTTON_CLICK;
    }
}

