/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.linked;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;

public class LinkRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult target = mc.field_71476_x;
        if (target == null || !(target instanceof BlockRayTraceResult)) {
            return;
        }
        ClientWorld world = mc.field_71441_e;
        BlockRayTraceResult result = (BlockRayTraceResult)target;
        BlockPos pos = result.func_216350_a();
        LinkBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)world, pos, LinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        TranslationTextComponent freq1 = Lang.translate("logistics.firstFrequency", new Object[0]);
        TranslationTextComponent freq2 = Lang.translate("logistics.secondFrequency", new Object[0]);
        for (boolean first : Iterate.trueAndFalse) {
            AxisAlignedBB bb = new AxisAlignedBB(Vector3d.field_186680_a, Vector3d.field_186680_a).func_186662_g(0.25);
            TranslationTextComponent label = first ? freq1 : freq2;
            boolean hit = behaviour.testHit(first, target.func_216347_e());
            ValueBoxTransform transform = first ? behaviour.firstSlot : behaviour.secondSlot;
            ValueBox box = new ValueBox((ITextComponent)label, bb, pos).withColors(6299416, 12008493).offsetLabel(behaviour.textShift).passive(!hit);
            CreateClient.OUTLINER.showValueBox(Pair.of((Object)first, (Object)pos), box.transform(transform)).lineWidth(0.015625f).withFaceTexture(hit ? AllSpecialTextures.THIN_CHECKERED : null).highlightFace(result.func_216354_b());
        }
    }

    public static void renderOnTileEntity(SmartTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (te == null || te.func_145837_r()) {
            return;
        }
        LinkBehaviour behaviour = te.getBehaviour(LinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        for (boolean first : Iterate.trueAndFalse) {
            ValueBoxTransform transform = first ? behaviour.firstSlot : behaviour.secondSlot;
            ItemStack stack = first ? behaviour.frequencyFirst.getStack() : behaviour.frequencyLast.getStack();
            ms.func_227860_a_();
            transform.transform(te.func_195044_w(), ms);
            ValueBoxRenderer.renderItemIntoValueBox(stack, ms, buffer, light, overlay);
            ms.func_227865_b_();
        }
    }
}

