/*
 * Decompiled with CFR 0.152.
 */
package djofox.crowns.materials;

import djofox.crowns.init.ItemInit;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum ArmourMaterialList implements IArmorMaterial
{
    LEATHER_CROWN("leather_crown", 40, new int[]{1, 2, 3, 1}, 1, (Item)ItemInit.binding.get(), "entity.experience_orb.pickup", 1.0f, 0.0f),
    CHAINMAIL_CROWN("chainmail_crown", 40, new int[]{2, 5, 6, 2}, 1, (Item)ItemInit.binding.get(), "entity.experience_orb.pickup", 1.0f, 0.0f),
    GOLD_CROWN("gold_crown", 40, new int[]{2, 5, 6, 2}, 1, (Item)ItemInit.binding.get(), "entity.experience_orb.pickup", 1.0f, 0.0f),
    IRON_CROWN("iron_crown", 40, new int[]{2, 6, 7, 2}, 1, (Item)ItemInit.binding.get(), "entity.experience_orb.pickup", 1.0f, 0.0f),
    DIAMOND_CROWN("diamond_crown", 40, new int[]{2, 5, 6, 3}, 1, (Item)ItemInit.binding.get(), "entity.experience_orb.pickup", 1.0f, 0.0f),
    NETHERITE_CROWN("netherite_crown", 40, new int[]{3, 6, 8, 4}, 1, (Item)ItemInit.binding.get(), "entity.experience_orb.pickup", 1.0f, 0.0f),
    SHULKER_CROWN("shulker_crown", 40, new int[]{4, 7, 8, 5}, 1, (Item)ItemInit.binding.get(), "entity.shulker.ambient", 1.0f, -1.25f);

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final String equipSound;
    private int[] damageReductionAmounts;
    private final int durability;
    private final int enchantability;
    private final float toughness;
    private final float kb;
    private Item repairItem;

    private ArmourMaterialList(String nameIn, int durability, int[] damageReductionAmounts, int enchantability, Item repairItem, String equipSound, float toughness, float kb) {
        this.name = nameIn;
        this.durability = durability;
        this.damageReductionAmounts = damageReductionAmounts;
        this.enchantability = enchantability;
        this.toughness = toughness;
        this.kb = kb;
        this.equipSound = equipSound;
        this.repairItem = repairItem;
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public SoundEvent func_200899_b() {
        return new SoundEvent(new ResourceLocation(this.equipSound));
    }

    public Ingredient func_200898_c() {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.repairItem});
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_200897_d() {
        return "crowns:" + this.name;
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public int func_200902_b(EquipmentSlotType slot) {
        return this.damageReductionAmounts[slot.func_188454_b()];
    }

    public int func_200896_a(EquipmentSlotType slot) {
        return MAX_DAMAGE_ARRAY[slot.func_188454_b()] * this.durability;
    }

    public float func_230304_f_() {
        return this.kb;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

