/*
 * Decompiled with CFR 0.152.
 */
package com.plop.cubeplus;

import com.plop.cubeplus.common.DynBlock.FormMats;
import com.plop.cubeplus.common.RegistryHandler;
import com.plop.cubeplus.common.config.Config;
import com.plop.cubeplus.common.item.cpItems;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cubeplus")
@Mod.EventBusSubscriber(modid="cubeplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CubePlus {
    public static final String MOD_ID = "cubeplus";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup TAB = new ItemGroup("TabName"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)RegistryHandler.STONE_STAIRS_4STEPS.get());
        }
    };

    public CubePlus() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.config);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        modEventBus.addListener(this::doClientStuff);
        Config.loadConfig(Config.config, FMLPaths.CONFIGDIR.get().resolve("cubeplus.toml").toString());
        FormMats.Init();
        RegistryHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void createBlockItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        RegistryHandler.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().func_200916_a(TAB);
            BlockItem blockItem = new BlockItem(block, properties);
            ResourceLocation location = RegistryHandler.getBlockItemName(block.getRegistryName());
            blockItem.setRegistryName(location);
            registry.register((IForgeRegistryEntry)blockItem);
        });
        cpItems.init((IForgeRegistry<Item>)registry);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderType rendertype = RenderType.func_228641_d_();
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.ACACIA_PLANKS_WOOD_SIMPLE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.ACACIA_PLANKS_WOOD_SQUARE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.BIRCH_PLANKS_WOOD_SIMPLE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.BIRCH_PLANKS_WOOD_SQUARE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.DARK_OAK_PLANKS_WOOD_SIMPLE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.DARK_OAK_PLANKS_WOOD_SQUARE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.JUNGLE_PLANKS_WOOD_SIMPLE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.JUNGLE_PLANKS_WOOD_SQUARE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.OAK_PLANKS_WOOD_SIMPLE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.OAK_PLANKS_WOOD_SQUARE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.SPRUCE_PLANKS_WOOD_SIMPLE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.SPRUCE_PLANKS_WOOD_SQUARE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.CRIMSON_PLANKS_WOOD_SIMPLE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.CRIMSON_PLANKS_WOOD_SQUARE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.WARPED_PLANKS_WOOD_SIMPLE_WINDOW.get()), (RenderType)rendertype);
        RenderTypeLookup.setRenderLayer((Block)((Block)RegistryHandler.WARPED_PLANKS_WOOD_SQUARE_WINDOW.get()), (RenderType)rendertype);
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    public static void log(String text) {
        String szPath = "debug.txt";
        text = text + "\n";
        File pFile = new File(szPath);
        try {
            if (pFile.exists() || pFile.createNewFile()) {
                byte[] byData = Files.readAllBytes(Paths.get(szPath, new String[0]));
                byte[] byFinal = new byte[byData.length + text.getBytes().length];
                System.arraycopy(byData, 0, byFinal, 0, byData.length);
                System.arraycopy(text.getBytes(), 0, byFinal, byData.length, text.getBytes().length);
                Files.write(Paths.get(szPath, new String[0]), byFinal, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info(text);
    }
}

