/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.config;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.crosshair.property.ICrosshairProperty;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Map;

public final class ConfigManager {
    private final String comment = "#";
    private final String[] header = new String[]{String.format("%s %s v%s", "#", "Custom Crosshair Mod", "1.3.4-forge"), String.format("%s Made by Sparkless101", "#"), String.format("%s ------------------------------------", "#"), String.format("%s %s", "#", "https://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/"), String.format("%s %s", "#", "https://www.curseforge.com/projects/242995/"), String.format("%s ------------------------------------", "#"), String.format("%s This config file contains the properties of the crosshair and mod properties. Feel free to edit them.", "#"), String.format("%s ------------------------------------", "#")};
    private final String fileName;
    private final Map<String, ICrosshairProperty<?>> properties;

    public ConfigManager(String fileName, Map<String, ICrosshairProperty<?>> properties) {
        this.fileName = fileName;
        this.properties = properties;
    }

    public boolean read() {
        boolean bl;
        BufferedReader reader = new BufferedReader(new FileReader(this.fileName));
        try {
            String currentLine;
            CustomCrosshairMod.INSTANCE.log("Config Manager (Read)", "Started reading file '{}'.", this.fileName);
            while ((currentLine = reader.readLine()) != null) {
                String[] lineSplit;
                if (currentLine.startsWith(this.comment) || (lineSplit = currentLine.split(":")).length == 0) continue;
                String alias = lineSplit[0].trim().toLowerCase();
                String value = lineSplit[1].trim().toLowerCase();
                ICrosshairProperty<?> property = this.properties.get(alias);
                if (property == null) continue;
                property.setFromConfig(value);
                CustomCrosshairMod.INSTANCE.log("Config Manager (Read)", "Set property '{}' to '{}'.", property.alias(), property.get());
            }
            CustomCrosshairMod.INSTANCE.log("Config Manager (Read)", "Finished reading file '{}'.", this.fileName);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    public boolean write() {
        boolean bl;
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName));
        try {
            CustomCrosshairMod.INSTANCE.log("Config Manager (Write)", "Start writing file '{}'.", this.fileName);
            for (String line : this.header) {
                writer.write(line);
                writer.newLine();
            }
            for (ICrosshairProperty iCrosshairProperty : this.properties.values()) {
                writer.write(String.format("%s:%s", iCrosshairProperty.alias(), iCrosshairProperty.forConfig()));
                writer.newLine();
            }
            CustomCrosshairMod.INSTANCE.log("Config Manager (Write)", "Finished writing file '{}'.", this.fileName);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        writer.close();
        return bl;
    }
}

