/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.crosshair.style.CrosshairStyleFactory;
import com.wjbaker.ccm.crosshair.style.ICrosshairStyle;
import com.wjbaker.ccm.render.RenderManager;
import com.wjbaker.ccm.type.RGBA;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class CrosshairRenderManager {
    private final CustomCrosshair crosshair;
    private final RenderManager renderManager;
    private final CrosshairStyleFactory crosshairStyleFactory;
    private final Set<Item> itemCooldownItems = ImmutableSet.of((Object)Items.f_42584_, (Object)Items.f_42730_);

    public CrosshairRenderManager(CustomCrosshair crosshair) {
        this.crosshair = crosshair;
        this.renderManager = new RenderManager();
        this.crosshairStyleFactory = new CrosshairStyleFactory();
    }

    public void draw(int x, int y) {
        ComputedProperties computedProperties = new ComputedProperties(this.crosshair);
        if (!computedProperties.isVisible()) {
            return;
        }
        PoseStack matrixStack = new PoseStack();
        RenderGameOverlayEvent eventParent = new RenderGameOverlayEvent(matrixStack, 1.0f, Minecraft.m_91087_().m_91268_());
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.PreLayer(matrixStack, eventParent, ForgeIngameGui.CROSSHAIR_ELEMENT));
        ICrosshairStyle style = this.crosshairStyleFactory.from((CrosshairStyle)((Object)this.crosshair.style.get()), this.crosshair);
        boolean isItemCooldownEnabled = (Boolean)this.crosshair.isItemCooldownEnabled.get();
        boolean isDotEnabled = (Boolean)this.crosshair.isDotEnabled.get();
        if (isItemCooldownEnabled) {
            this.drawItemCooldownIndicator(matrixStack, computedProperties, x, y);
        }
        if (isDotEnabled && this.crosshair.style.get() != CrosshairStyle.DEFAULT) {
            this.renderManager.drawCircle(matrixStack, x, y, 0.5f, 1.0f, (RGBA)this.crosshair.dotColour.get());
        }
        this.preTransformation(matrixStack, x, y);
        style.draw(matrixStack, 0, 0, computedProperties);
        this.postTransformation(matrixStack);
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.PostLayer(matrixStack, eventParent, ForgeIngameGui.CROSSHAIR_ELEMENT));
    }

    private void preTransformation(PoseStack matrixStack, int x, int y) {
        Integer rotation = (Integer)this.crosshair.rotation.get();
        int scale = (Integer)this.crosshair.scale.get() - 2;
        float windowScaling = (float)Minecraft.m_91087_().m_91268_().m_85449_() / 2.0f;
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)rotation.intValue()));
        matrixStack.m_85841_((float)scale / 100.0f / windowScaling, (float)scale / 100.0f / windowScaling, 1.0f);
    }

    private void postTransformation(PoseStack matrixStack) {
        matrixStack.m_85849_();
    }

    private void drawItemCooldownIndicator(PoseStack matrixStack, ComputedProperties computedProperties, int x, int y) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        RGBA colour = (RGBA)this.crosshair.itemCooldownColour.get();
        int width = (Integer)this.crosshair.width.get();
        int height = (Integer)this.crosshair.height.get();
        int maxSize = Math.max(width, height);
        int offset = 3;
        for (Item item : this.itemCooldownItems) {
            float cooldown = player.m_36335_().m_41521_(item, 0.0f);
            if (cooldown == 0.0f) continue;
            int progress = Math.round(360.0f - 360.0f * cooldown);
            this.renderManager.drawPartialCircle(matrixStack, x, y, computedProperties.gap() + maxSize + offset, 0, progress, 2.0f, colour);
            offset += 3;
        }
    }
}

