/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.style.styles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.AbstractCrosshairStyle;
import com.wjbaker.ccm.type.RGBA;

public final class ArrowStyle
extends AbstractCrosshairStyle {
    public ArrowStyle(CustomCrosshair crosshair) {
        super(crosshair);
    }

    @Override
    public void draw(PoseStack matrixStack, int x, int y, ComputedProperties computedProperties) {
        boolean isOutlineEnabled = (Boolean)this.crosshair.isOutlineEnabled.get();
        int width = (Integer)this.crosshair.width.get();
        int height = (Integer)this.crosshair.height.get();
        int thickness = (Integer)this.crosshair.thickness.get();
        if (isOutlineEnabled) {
            RGBA outlineColour = (RGBA)this.crosshair.outlineColour.get();
            this.renderManager.drawLines(matrixStack, new float[]{x - width - 1, y + height + 1, x, y, x, y, x + width + 1, y + height + 1}, thickness + 3, outlineColour);
            this.renderManager.drawCircle(matrixStack, x, y, thickness == 1 ? 0.5f : (float)thickness / 5.0f, 1.0f, outlineColour);
        }
        this.renderManager.drawLines(matrixStack, new float[]{x - width, y + height, x, y, x, y, x + width, y + height}, thickness, computedProperties.colour());
    }
}

