/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client.particle;

import com.naterbobber.darkerdepths.core.registries.DDParticleTypes;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DrippingParticle
extends SpriteTexturedParticle {
    private final Fluid fluid;
    protected boolean fullBright;

    private DrippingParticle(ClientWorld world, double x, double y, double z, Fluid fluid) {
        super(world, x, y, z);
        this.func_187115_a(0.01f, 0.01f);
        this.field_70545_g = 0.06f;
        this.fluid = fluid;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    protected int func_189214_a(float partialTick) {
        return this.fullBright ? 240 : super.func_189214_a(partialTick);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.ageParticle();
        if (!this.field_187133_m) {
            this.field_187130_j -= (double)this.field_70545_g;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.updateMotion();
            if (!this.field_187133_m) {
                this.field_187129_i *= (double)0.98f;
                this.field_187130_j *= (double)0.98f;
                this.field_187131_k *= (double)0.98f;
                BlockPos blockpos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
                FluidState fluidstate = this.field_187122_b.func_204610_c(blockpos);
                if (fluidstate.func_206886_c() == this.fluid && this.field_187127_g < (double)((float)blockpos.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_187122_b, blockpos))) {
                    this.func_187112_i();
                }
            }
        }
    }

    protected void ageParticle() {
        if (this.field_70547_e-- <= 0) {
            this.func_187112_i();
        }
    }

    protected void updateMotion() {
    }

    static /* synthetic */ float access$100(DrippingParticle x0) {
        return x0.field_70545_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LandingResinFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public LandingResinFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Landing landing = new Landing(worldIn, x, y, z, Fluids.field_204541_a);
            landing.fullBright = true;
            ((DrippingParticle)landing).field_70547_e = (int)(28.0 / (Math.random() * 0.8 + 0.2));
            landing.func_70538_b(0.97f, 0.56f, 0.22f);
            landing.func_217568_a(this.spriteSet);
            return landing;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FallingResinFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FallingResinFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingLiquid falling = new FallingLiquid(worldIn, x, y, z, Fluids.field_204541_a, (IParticleData)DDParticleTypes.LANDING_RESIN.get());
            falling.fullBright = true;
            ((DrippingParticle)falling).field_70545_g = 0.01f;
            falling.func_70538_b(0.97f, 0.56f, 0.22f);
            falling.func_217568_a(this.spriteSet);
            return falling;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DrippingResinFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public DrippingResinFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Dripping dripping = new Dripping(worldIn, x, y, z, Fluids.field_204541_a, (IParticleData)DDParticleTypes.FALLING_RESIN.get());
            dripping.fullBright = true;
            Dripping dripping2 = dripping;
            ((DrippingParticle)dripping2).field_70545_g = ((DrippingParticle)dripping2).field_70545_g * 0.01f;
            ((DrippingParticle)dripping).field_70547_e = 100;
            dripping.func_70538_b(0.97f, 0.56f, 0.22f);
            dripping.func_217568_a(this.spriteSet);
            return dripping;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Landing
    extends DrippingParticle {
        private Landing(ClientWorld world, double x, double y, double z, Fluid fluid) {
            super(world, x, y, z, fluid);
            this.field_70547_e = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Falling
    extends DrippingParticle {
        Falling(ClientWorld world, double x, double y, double z, Fluid fluid) {
            this(world, x, y, z, fluid, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        Falling(ClientWorld world, double x, double y, double z, Fluid fluid, int maxAge) {
            super(world, x, y, z, fluid);
            this.field_70547_e = maxAge;
        }

        @Override
        protected void updateMotion() {
            if (this.field_187132_l) {
                this.func_187112_i();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallingLiquid
    extends Falling {
        protected final IParticleData nextParticle;

        FallingLiquid(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData nextParticle) {
            super(world, x, y, z, fluid);
            this.nextParticle = nextParticle;
        }

        @Override
        protected void updateMotion() {
            if (this.field_187132_l) {
                this.func_187112_i();
                this.field_187122_b.func_195594_a(this.nextParticle, this.field_187126_f, this.field_187127_g, this.field_187128_h, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Dripping
    extends DrippingParticle {
        protected final IParticleData nextParticle;

        Dripping(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData nextParticle) {
            super(world, x, y, z, fluid);
            this.nextParticle = nextParticle;
            this.field_70545_g *= 0.02f;
            this.field_70547_e = 40;
        }

        @Override
        protected void ageParticle() {
            if (this.field_70547_e-- <= 0) {
                this.func_187112_i();
                this.field_187122_b.func_195594_a(this.nextParticle, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i, this.field_187130_j, this.field_187131_k);
            }
        }

        @Override
        protected void updateMotion() {
            this.field_187129_i *= 0.02;
            this.field_187130_j *= 0.02;
            this.field_187131_k *= 0.02;
        }
    }
}

