/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class RopeBlock
extends Block
implements IBucketPickupHandler,
ILiquidContainer {
    public static final EnumProperty<RopePart> PART = EnumProperty.func_177709_a((String)"part", RopePart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public RopeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)((Object)RopePart.MIDDLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(PART) == RopePart.BOTTOM) {
            return Block.func_208617_a((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        }
        if (state.func_177229_b(PART) == RopePart.MIDDLE) {
            return Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        }
        return VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)7.0, (double)12.0, (double)11.0, (double)9.0, (double)16.0, (double)13.0), Block.func_208617_a((double)7.0, (double)12.0, (double)3.0, (double)9.0, (double)16.0, (double)5.0), Block.func_208617_a((double)7.0, (double)12.0, (double)5.0, (double)9.0, (double)14.0, (double)11.0)});
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return (worldIn.func_180495_p(pos.func_177984_a()).func_224755_d((IBlockReader)worldIn, pos, Direction.DOWN) || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof RopeBlock) && !(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof AirBlock);
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean water = context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() == Blocks.field_150355_j;
        BlockState state = super.func_196258_a(context);
        if (state != null) {
            if (this.isRopeBottom((IWorld)context.func_195991_k(), context.func_195995_a())) {
                state = (BlockState)state.func_206870_a(PART, (Comparable)((Object)RopePart.BOTTOM));
            } else if (this.isRopeTop((IWorld)context.func_195991_k(), context.func_195995_a())) {
                state = (BlockState)state.func_206870_a(PART, (Comparable)((Object)RopePart.TOP));
            }
        } else {
            return null;
        }
        return (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        stateIn = this.isRopeBottom(worldIn, currentPos) ? (BlockState)stateIn.func_206870_a(PART, (Comparable)((Object)RopePart.BOTTOM)) : (this.isRopeTop(worldIn, currentPos) ? (BlockState)stateIn.func_206870_a(PART, (Comparable)((Object)RopePart.TOP)) : (BlockState)stateIn.func_206870_a(PART, (Comparable)((Object)RopePart.MIDDLE)));
        return this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos) : Blocks.field_150350_a.func_176223_P();
    }

    public boolean isRopeBottom(IWorld world, BlockPos pos) {
        return !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof RopeBlock);
    }

    public boolean isRopeTop(IWorld world, BlockPos pos) {
        return !(world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof RopeBlock);
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, FluidState fluidState) {
        if (fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), fluidState.func_206886_c().func_205569_a((IWorldReader)world));
            }
            return true;
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, WATERLOGGED});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public static enum RopePart implements IStringSerializable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private RopePart(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

