/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.naterbobber.darkerdepths.common.math.FloatProvider;
import com.naterbobber.darkerdepths.common.math.FloatProviderType;
import com.naterbobber.darkerdepths.core.util.helpers.MathUtils;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.math.MathHelper;

public class ClampedNormalFloatProvider
extends FloatProvider {
    public static final Codec<ClampedNormalFloatProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("mean").forGetter(provider -> Float.valueOf(provider.mean)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(provider -> Float.valueOf(provider.deviation)), (App)Codec.FLOAT.fieldOf("min").forGetter(provider -> Float.valueOf(provider.min)), (App)Codec.FLOAT.fieldOf("max").forGetter(provider -> Float.valueOf(provider.max))).apply((Applicative)instance, ClampedNormalFloatProvider::new)).comapFlatMap(provider -> provider.max < provider.min ? DataResult.error((String)("Max must be larger than min: [" + provider.min + ", " + provider.max + "]")) : DataResult.success((Object)provider), Function.identity());
    private final float mean;
    private final float deviation;
    private final float min;
    private final float max;

    public static ClampedNormalFloatProvider of(float mean, float deviation, float min, float max) {
        return new ClampedNormalFloatProvider(mean, deviation, min, max);
    }

    public ClampedNormalFloatProvider(float mean, float deviation, float min, float max) {
        this.mean = mean;
        this.deviation = deviation;
        this.min = min;
        this.max = max;
    }

    @Override
    public float get(Random rand) {
        return ClampedNormalFloatProvider.get(rand, this.mean, this.deviation, this.min, this.max);
    }

    public static float get(Random rand, float mean, float deviation, float min, float max) {
        return MathHelper.func_76131_a((float)MathUtils.nextGaussian(rand, mean, deviation), (float)min, (float)max);
    }

    @Override
    public float getMin() {
        return this.min;
    }

    @Override
    public float getMax() {
        return this.max;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.CLAMPED_NORMAL;
    }

    public String toString() {
        return "normal(" + this.mean + ", " + this.deviation + ") in [" + this.min + '-' + this.max + ']';
    }
}

