/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.naterbobber.darkerdepths.common.math.FloatProvider;
import com.naterbobber.darkerdepths.common.math.FloatProviderType;
import com.naterbobber.darkerdepths.core.util.helpers.MathUtils;
import java.util.Random;
import java.util.function.Function;

public class UniformFloatProvider
extends FloatProvider {
    public static final Codec<UniformFloatProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_inclusive").forGetter(config -> Float.valueOf(config.min)), (App)Codec.FLOAT.fieldOf("max_exclusive").forGetter(config -> Float.valueOf(config.max))).apply((Applicative)instance, UniformFloatProvider::new)).comapFlatMap(config -> config.max < config.min ? DataResult.error((String)("Max must be at least min, min_inclusive: " + config.min + ", max_inclusive: " + config.max)) : DataResult.success((Object)config), Function.identity());
    private final float min;
    private final float max;

    private UniformFloatProvider(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public static UniformFloatProvider create(float min, float max) {
        if (max <= min) {
            throw new IllegalArgumentException("Max must exceed min");
        }
        return new UniformFloatProvider(min, max);
    }

    @Override
    public float get(Random rand) {
        return MathUtils.nextBetween(rand, this.min, this.max);
    }

    @Override
    public float getMin() {
        return this.min;
    }

    @Override
    public float getMax() {
        return this.max;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.UNIFORM;
    }

    public String toString() {
        return "[" + this.min + '-' + this.max + ']';
    }
}

