/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen;

import com.blackgear.cavebiomes.core.registries.CaveBiomes;
import com.naterbobber.darkerdepths.common.world.gen.DDConfiguredFeatures;
import com.naterbobber.darkerdepths.common.world.gen.VanillaBiomeFeatures;
import com.naterbobber.darkerdepths.core.registries.DDEntityTypes;
import com.naterbobber.darkerdepths.core.registries.worldgen.DDBiomes;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class GlobalBiomeFeatures {
    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        GlobalBiomeManager manager = new GlobalBiomeManager(event);
        if (manager.matches((Biome)CaveBiomes.CAVE.get())) {
            BiomeFeatures.generateCaveFeatures(manager);
        }
        if (manager.matches((Biome)DDBiomes.MOLTEN_CAVERN.get())) {
            BiomeFeatures.generateMoltenCavernFeatures(manager);
        }
        if (manager.matches((Biome)DDBiomes.SANDY_CATACOMBS.get())) {
            BiomeFeatures.generateSandyCatacombsFeatures(manager);
        }
        if (manager.matches((Biome)DDBiomes.CRYSTAL_CAVE.get())) {
            BiomeFeatures.generateCrystalCaveFeatures(manager);
        }
        if (manager.matches((Biome)DDBiomes.GLOWSHROOM_CAVES.get())) {
            BiomeFeatures.generateGlowshroomCaveFeatures(manager);
        }
    }

    private static class GlobalBiomeManager {
        private final BiomeLoadingEvent event;

        public GlobalBiomeManager(BiomeLoadingEvent event) {
            this.event = event;
        }

        public Biome.Category getCategory() {
            return this.event.getCategory();
        }

        public ResourceLocation getName() {
            return this.event.getName();
        }

        public BiomeGenerationSettingsBuilder generation() {
            return this.event.getGeneration();
        }

        public MobSpawnInfoBuilder spawns() {
            return this.event.getSpawns();
        }

        public boolean matches(Biome object) {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(this.getName());
            return object == biome;
        }

        public boolean matches(RegistryKey<Biome> object) {
            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)this.getName());
            return object == key;
        }
    }

    static class BiomeFeatures {
        BiomeFeatures() {
        }

        private static void generateCaveFeatures(GlobalBiomeManager manager) {
            VanillaBiomeFeatures.addGlowshrooms(manager.generation());
            VanillaBiomeFeatures.addMineables(manager.generation());
        }

        private static void generateMoltenCavernFeatures(GlobalBiomeManager manager) {
            VanillaBiomeFeatures.addAmber(manager.generation());
            VanillaBiomeFeatures.addMoltenCavernDecorations(manager.generation());
            VanillaBiomeFeatures.addMineables(manager.generation());
            manager.generation().func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, DDConfiguredFeatures.MOLTEN_CAVERN_SPRING_OPEN);
            manager.generation().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, DDConfiguredFeatures.GEYSER);
            manager.generation().func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, DDConfiguredFeatures.MOLTEN_CAVERN_TERRAIN);
        }

        private static void generateSandyCatacombsFeatures(GlobalBiomeManager manager) {
            manager.generation().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, DDConfiguredFeatures.PETRIFIED_LOG_BRANCH);
            VanillaBiomeFeatures.addSandyCatacombsTerrain(manager.generation());
            VanillaBiomeFeatures.addCaveFossils(manager.generation());
            VanillaBiomeFeatures.addSandyCatacombsVegetation(manager.generation());
            VanillaBiomeFeatures.addSandyCatacombsCompat(manager.generation());
            VanillaBiomeFeatures.addMineables(manager.generation(), false);
        }

        private static void generateCrystalCaveFeatures(GlobalBiomeManager manager) {
            VanillaBiomeFeatures.addGlowshrooms(manager.generation());
            VanillaBiomeFeatures.addMineables(manager.generation());
        }

        private static void generateGlowshroomCaveFeatures(GlobalBiomeManager manager) {
            VanillaBiomeFeatures.addGlowshroomVegetation(manager.generation());
            VanillaBiomeFeatures.addMineables(manager.generation());
            manager.generation().func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, DDConfiguredFeatures.GLOWSHROOM_CAVE_TERRAIN);
            manager.spawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)DDEntityTypes.GLOWSHROOM_MONSTER.get(), 50, 1, 2));
        }
    }
}

