/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen.feature;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.common.blocks.SpeleothemBlock;
import com.naterbobber.darkerdepths.common.world.gen.feature.SpeleothemConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.registries.ForgeRegistries;

public class SpeleothemFeature
extends Feature<SpeleothemConfig> {
    public SpeleothemFeature(Codec<SpeleothemConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, SpeleothemConfig config) {
        if (world.func_175623_d(pos.func_177977_b())) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        Block replaceState = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "stone_speleothem"));
        for (int i = 0; i < 60; ++i) {
            int size = rand.nextInt(3) == 0 ? 2 : 3;
            mutable.func_239621_a_((Vector3i)pos, rand.nextInt(13) - 6, rand.nextInt(7) - 6, rand.nextInt(13) - 6);
            if (!world.func_175623_d((BlockPos)mutable)) continue;
            if (world.func_180495_p(mutable.func_177977_b()) == config.bottomState) {
                if (config.direction != Direction.UP) continue;
                this.generateStalagmite(size, (IWorld)world, (BlockPos)mutable, config.speleothem_type);
                continue;
            }
            if (world.func_180495_p(mutable.func_177984_a()) != config.bottomState) continue;
            this.generateStalactite(size, (IWorld)world, (BlockPos)mutable, config.speleothem_type);
        }
        return true;
    }

    private void generateStalagmite(int size, IWorld world, BlockPos pos, BlockState state) {
        if (size == 2) {
            this.func_230367_a_((IWorldWriter)world, pos, (BlockState)state.func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)SpeleothemBlock.SpeleothemSize.MEDIUM)));
            this.func_230367_a_((IWorldWriter)world, pos.func_177984_a(), (BlockState)state.func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)SpeleothemBlock.SpeleothemSize.SMALL)));
        } else {
            this.func_230367_a_((IWorldWriter)world, pos, (BlockState)state.func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)SpeleothemBlock.SpeleothemSize.BIG)));
            this.func_230367_a_((IWorldWriter)world, pos.func_177984_a(), (BlockState)state.func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)SpeleothemBlock.SpeleothemSize.MEDIUM)));
            this.func_230367_a_((IWorldWriter)world, pos.func_177981_b(2), (BlockState)state.func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)SpeleothemBlock.SpeleothemSize.SMALL)));
        }
    }

    private void generateStalactite(int size, IWorld world, BlockPos pos, BlockState state) {
        if (size == 2) {
            this.func_230367_a_((IWorldWriter)world, pos, (BlockState)state.func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)SpeleothemBlock.SpeleothemSize.MEDIUM)));
            this.func_230367_a_((IWorldWriter)world, pos.func_177977_b(), (BlockState)state.func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)SpeleothemBlock.SpeleothemSize.SMALL)));
        } else {
            this.func_230367_a_((IWorldWriter)world, pos, (BlockState)state.func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)SpeleothemBlock.SpeleothemSize.BIG)));
            this.func_230367_a_((IWorldWriter)world, pos.func_177977_b(), (BlockState)state.func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)SpeleothemBlock.SpeleothemSize.MEDIUM)));
            this.func_230367_a_((IWorldWriter)world, pos.func_177979_c(2), (BlockState)state.func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)SpeleothemBlock.SpeleothemSize.SMALL)));
        }
    }
}

