/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.core.api;

import com.naterbobber.darkerdepths.core.api.CoreRegistries;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;

public class Registries
extends CoreRegistries {
    public RegistryObject<SoundEvent> registerSoundEvent(String key) {
        return this.soundEvents.register(key, () -> new SoundEvent(new ResourceLocation("darkerdepths", key)));
    }

    public <E extends Effect> RegistryObject<E> registerEffect(String key, Supplier<? extends E> effect) {
        return this.effects.register(key, effect);
    }

    public <B extends Block> RegistryObject<B> registerBlock(String key, Supplier<? extends B> block) {
        return this.blocks.register(key, block);
    }

    public <T extends TileEntityType<?>> RegistryObject<T> registerTileEntity(String key, Supplier<? extends T> builder) {
        return this.tileEntities.register(key, builder);
    }

    public <B extends Block> RegistryObject<B> registerBlock(String key, Supplier<? extends B> block, ItemGroup group) {
        RegistryObject blocks = this.blocks.register(key, block);
        this.items.register(key, () -> new BlockItem((Block)blocks.get(), new Item.Properties().func_200916_a(group)));
        return blocks;
    }

    public <E extends Enchantment> RegistryObject<E> registerEnchantment(String key, Supplier<? extends E> enchantment) {
        return this.enchantments.register(key, enchantment);
    }

    public <E extends Entity> RegistryObject<EntityType<E>> registerEntity(String key, EntityType.Builder<E> builder) {
        return this.entityTypes.register(key, () -> builder.func_206830_a(new ResourceLocation("darkerdepths", key).toString()));
    }

    public <I extends Item> RegistryObject<I> registerItem(String key, Supplier<? extends I> item) {
        return this.items.register(key, item);
    }

    public <C extends ICarverConfig, CC extends ConfiguredCarver<C>> CC registerConfiguredCarver(String key, CC configuredFeature) {
        ResourceLocation ID = new ResourceLocation("darkerdepths", key);
        if (WorldGenRegistries.field_243652_d.func_148742_b().contains(ID)) {
            throw new IllegalStateException("The Configured Carver " + key + "already exists in the registry");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243652_d, (ResourceLocation)ID, configuredFeature);
        return configuredFeature;
    }

    public <C extends ISurfaceBuilderConfig, S extends SurfaceBuilder<C>> RegistryObject<S> registerSurfaceBuilder(String key, Supplier<? extends S> surfaceBuilder) {
        return this.surfaceBuilders.register(key, surfaceBuilder);
    }

    public <C extends ISurfaceBuilderConfig, CC extends ConfiguredSurfaceBuilder<C>> CC registerConfiguredSurfaceBuilder(String key, CC configuredFeature) {
        ResourceLocation ID = new ResourceLocation("darkerdepths", key);
        if (WorldGenRegistries.field_243651_c.func_148742_b().contains(ID)) {
            throw new IllegalStateException("The Configured Surface Builder " + key + "already exists in the registry");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243651_c, (ResourceLocation)ID, configuredFeature);
        return configuredFeature;
    }

    public <C extends IFeatureConfig, F extends Feature<C>> RegistryObject<F> registerFeature(String key, Supplier<? extends F> feature) {
        return this.features.register(key, feature);
    }

    public <C extends IFeatureConfig, F extends Feature<C>, CF extends ConfiguredFeature<C, F>> CF registerConfiguredFeature(String key, CF configuredFeature) {
        ResourceLocation ID = new ResourceLocation("darkerdepths", key);
        if (WorldGenRegistries.field_243653_e.func_148742_b().contains(ID)) {
            throw new IllegalStateException("The Configured Feature " + key + "already exists in the registry");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)ID, configuredFeature);
        return configuredFeature;
    }

    public <C extends IPlacementConfig, P extends Placement<C>> RegistryObject<P> registerPlacement(String key, Supplier<? extends P> placement) {
        return this.placements.register(key, placement);
    }

    public <B extends Biome> RegistryObject<B> registerBiome(String key, Supplier<? extends B> biome) {
        return this.biomes.register(key, biome);
    }

    public RegistryObject<BasicParticleType> registerParticle(String key, boolean alwaysShow) {
        return this.particleTypes.register(key, () -> new BasicParticleType(alwaysShow));
    }

    public ITag.INamedTag<Block> registerBlockTag(String key) {
        return BlockTags.func_199894_a((String)new ResourceLocation("darkerdepths", key).toString());
    }

    public ITag.INamedTag<Item> registerItemTag(String key) {
        return ItemTags.func_199901_a((String)new ResourceLocation("darkerdepths", key).toString());
    }

    public ITag.INamedTag<Fluid> registerFluidTag(String key) {
        return FluidTags.func_206956_a((String)new ResourceLocation("darkerdepths", key).toString());
    }

    public ITag.INamedTag<EntityType<?>> registerEntityTag(String key) {
        return EntityTypeTags.func_232896_a_((String)new ResourceLocation("darkerdepths", key).toString());
    }

    public <B extends Block> RegistryObject<B> registerCompatBlock(String modId, String key, Supplier<? extends B> block, ItemGroup group) {
        RegistryObject blocks = this.blocks.register(key, block);
        this.items.register(key, () -> new BlockItem((Block)blocks.get(), new Item.Properties().func_200916_a(this.getGroup(modId, group))));
        return blocks;
    }

    public ItemGroup getGroup(String modId, ItemGroup group) {
        return ModList.get().isLoaded(modId) ? group : null;
    }
}

