/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.client.renderer.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fuzs.diagonalfences.DiagonalFences;
import fuzs.diagonalfences.client.json.adapter.BlockPartAdapter;
import fuzs.diagonalfences.client.util.AssetLocations;
import fuzs.puzzleslib.json.JsonConfigFileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateModelUnit {
    private final IResourceManager resourceManager;
    public final Block block;
    @Nonnull
    public final ResourceLocation blockLocation;
    private final Map<ResourceLocation, JsonElement> resources = Maps.newHashMap();
    private final Map<Pair<String, String>, String> propertyConverter;
    private final Consumer<List<BlockPart>> elementsConverter;

    public BlockStateModelUnit(IResourceManager resourceManager, Block block, Map<Pair<String, String>, String> propertyConverter, Consumer<List<BlockPart>> elementsConverter) {
        this.resourceManager = resourceManager;
        this.block = block;
        this.blockLocation = block.getRegistryName();
        this.propertyConverter = propertyConverter;
        this.elementsConverter = elementsConverter;
    }

    public Map<ResourceLocation, JsonElement> load() {
        this.resources.clear();
        JsonElement blockStatesElement = this.loadResource(AssetLocations.getBlockStatesPath(this.blockLocation), reader -> (JsonElement)JsonConfigFileUtil.GSON.fromJson(reader, JsonElement.class));
        if (blockStatesElement instanceof JsonObject && blockStatesElement.getAsJsonObject().has("multipart")) {
            ArrayList newSelectors = Lists.newArrayList();
            JsonArray selectorArray = blockStatesElement.getAsJsonObject().getAsJsonArray("multipart");
            for (JsonElement selectorElement : selectorArray) {
                JsonObject selectorObject = selectorElement.getAsJsonObject();
                if (!selectorObject.has("when")) continue;
                JsonObject conditionObject = selectorObject.getAsJsonObject("when");
                JsonElement variantListElement = selectorObject.get("apply");
                this.makeNewSelector(conditionObject, variantListElement).ifPresent(newSelectors::add);
            }
            newSelectors.forEach(arg_0 -> ((JsonArray)selectorArray).add(arg_0));
            this.resources.put(AssetLocations.getBlockStatesPath(this.blockLocation), blockStatesElement);
        }
        return ImmutableMap.copyOf(this.resources);
    }

    private Optional<JsonElement> makeNewSelector(JsonObject conditionObject, JsonElement variantListElement) {
        boolean isConvertible = conditionObject.entrySet().stream().map(entry -> Pair.of(entry.getKey(), (Object)((JsonElement)entry.getValue()).getAsString())).anyMatch(this.propertyConverter::containsKey);
        if (isConvertible) {
            JsonObject newSelectorObject = new JsonObject();
            JsonObject newConditionObject = this.getConvertedCondition(conditionObject);
            newSelectorObject.add("when", (JsonElement)newConditionObject);
            JsonElement newVariantListElement = this.getConvertedVariantList(variantListElement);
            newSelectorObject.add("apply", newVariantListElement);
            return Optional.of(newSelectorObject);
        }
        return Optional.empty();
    }

    private JsonObject getConvertedCondition(JsonObject whenObject) {
        JsonObject convertedWhenObject = new JsonObject();
        for (Map.Entry entry : whenObject.entrySet()) {
            String property = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            property = this.propertyConverter.getOrDefault(Pair.of((Object)property, (Object)value), property);
            convertedWhenObject.addProperty(property, value);
        }
        return convertedWhenObject;
    }

    private JsonElement getConvertedVariantList(JsonElement variantElement) {
        if (variantElement.isJsonArray()) {
            JsonArray variantListArray = new JsonArray();
            for (JsonElement variantListElement : variantElement.getAsJsonArray()) {
                variantListArray.add(this.getConvertedVariant(variantListElement));
            }
            return variantListArray;
        }
        return this.getConvertedVariant(variantElement);
    }

    private JsonElement getConvertedVariant(JsonElement variantElement) {
        JsonObject newVariantObject = new JsonObject();
        for (Map.Entry variantEntry : variantElement.getAsJsonObject().entrySet()) {
            String key = (String)variantEntry.getKey();
            JsonElement value = (JsonElement)variantEntry.getValue();
            if (key.equals("model")) {
                ResourceLocation modelLocation = new ResourceLocation(value.getAsString());
                ResourceLocation convertedModelLocation = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a() + "_" + Integer.toHexString(this.hashCode()));
                value = new JsonPrimitive(convertedModelLocation.toString());
                this.makeModel(modelLocation, convertedModelLocation);
            }
            newVariantObject.add(key, value);
        }
        return newVariantObject;
    }

    private void makeModel(ResourceLocation modelLocation, ResourceLocation convertedModelLocation) {
        JsonElement modelElement;
        if (!this.resources.containsKey(AssetLocations.getBlockModelPath(convertedModelLocation)) && (modelElement = this.loadResource(AssetLocations.getBlockModelPath(modelLocation), reader -> (JsonElement)JsonConfigFileUtil.GSON.fromJson(reader, JsonElement.class))) instanceof JsonObject) {
            List<BlockPart> elements = this.getConvertedModelElements(modelLocation);
            modelElement.getAsJsonObject().add("elements", BlockPartAdapter.GSON.toJsonTree(elements));
            this.resources.put(AssetLocations.getBlockModelPath(convertedModelLocation), modelElement);
        }
    }

    private List<BlockPart> getConvertedModelElements(ResourceLocation modelLocation) {
        BlockModel blockModel = this.loadModel(modelLocation);
        blockModel.func_225614_a_(this::loadModel, (Set)Sets.newHashSet());
        List elements = blockModel.func_178298_a();
        this.elementsConverter.accept(elements);
        return elements;
    }

    private BlockModel loadModel(ResourceLocation location) {
        return this.loadResource(AssetLocations.getBlockModelPath(location), reader -> {
            BlockModel blockmodel = BlockModel.func_178307_a((Reader)reader);
            blockmodel.field_178317_b = location.toString();
            return blockmodel;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T loadResource(ResourceLocation jsonPath, Function<Reader, T> transform) {
        try (InputStream inputstream = this.resourceManager.func_199002_a(jsonPath).func_199027_b();){
            InputStreamReader reader = new InputStreamReader(inputstream, StandardCharsets.UTF_8);
            Reader t = transform.apply(reader);
            return (T)t;
        }
        catch (IOException e) {
            DiagonalFences.LOGGER.warn("Exception loading resource definition: {}: {}", (Object)jsonPath, (Object)e);
            return null;
        }
    }
}

