/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.mixin;

import com.mojang.serialization.MapCodec;
import fuzs.diagonalfences.block.IEightWayBlock;
import fuzs.diagonalfences.element.DiagonalFencesElement;
import fuzs.diagonalfences.mixin.accessor.IStateHolderAccessor;
import fuzs.diagonalfences.state.ExposedStateContainerBuilder;
import fuzs.puzzleslib.util.PuzzlesUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FenceBlock.class})
public abstract class FenceBlockMixin
extends FourWayBlock
implements IEightWayBlock {
    private boolean hasProperties;
    private Object2IntMap<BlockState> statePaletteMap;

    public FenceBlockMixin(float nodeWidth, float extensionWidth, float nodeHeight, float extensionHeight, float collisionY, AbstractBlock.Properties properties) {
        super(nodeWidth, extensionWidth, nodeHeight, extensionHeight, collisionY, properties);
    }

    protected VoxelShape[] func_196408_a(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        if (this.hasProperties()) {
            return this.getShapes(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight);
        }
        return super.func_196408_a(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight);
    }

    protected int func_196406_i(BlockState state) {
        if (this.hasProperties()) {
            if (this.statePaletteMap == null) {
                this.statePaletteMap = new Object2IntOpenHashMap();
            }
            return this.statePaletteMap.computeIntIfAbsent((Object)state, this::makeIndex);
        }
        return super.func_196406_i(state);
    }

    public void func_196248_b(BlockState state, IWorld world, BlockPos pos, int flags, int recursionLeft) {
        if (this.canConnectDiagonally()) {
            this.updateDiagonalNeighbors2(state, world, pos, flags, recursionLeft);
        }
    }

    @Shadow
    public abstract boolean func_220111_a(BlockState var1, boolean var2, Direction var3);

    @Shadow
    private boolean func_235493_c_(Block block) {
        throw new IllegalStateException();
    }

    @Override
    public boolean hasProperties() {
        return this.hasProperties;
    }

    @Override
    public boolean canConnect(IBlockReader iblockreader, BlockPos position, BlockState state, Direction direction) {
        return this.func_220111_a(state, state.func_224755_d(iblockreader, position, direction), direction);
    }

    @Override
    public boolean canConnectDiagonally() {
        try {
            return this.hasProperties() && !this.func_203417_a((ITag)DiagonalFencesElement.NON_DIAGONAL_FENCES_TAG);
        }
        catch (Exception exception) {
            return this.hasProperties();
        }
    }

    @Override
    public boolean canConnectDiagonally(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        return block instanceof FenceBlock && ((IEightWayBlock)block).canConnectDiagonally() && this.func_235493_c_(block);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(AbstractBlock.Properties properties, CallbackInfo callbackInfo) {
        if (this.hasProperties()) {
            this.func_180632_j(this.getDefaultStates(this.func_176223_P()));
            ExposedStateContainerBuilder builder = (ExposedStateContainerBuilder)((Object)PuzzlesUtil.make(new ExposedStateContainerBuilder(), arg_0 -> ((FenceBlockMixin)this).func_206840_a(arg_0)));
            ExposedStateContainerBuilder additionalBuilder = (ExposedStateContainerBuilder)((Object)PuzzlesUtil.make(new ExposedStateContainerBuilder(), this::fillStateContainer2));
            MapCodec mapcodec = this.makeLenientMapCodec(() -> ((Block)((Block)this.field_176227_L.func_177622_c())).func_176223_P(), builder, additionalBuilder);
            Stream.concat(Stream.of(this.func_176223_P()), this.field_176227_L.func_177619_a().stream()).map(state -> (IStateHolderAccessor)state).forEach(state -> state.setCodec(mapcodec));
        }
    }

    @Inject(method={"fillStateContainer"}, at={@At(value="TAIL")})
    protected void fillStateContainer(StateContainer.Builder<Block, BlockState> builder, CallbackInfo callbackInfo) {
        this.hasProperties = true;
        this.fillStateContainer2(builder);
    }

    @Inject(method={"getStateForPlacement"}, at={@At(value="HEAD")}, cancellable=true)
    public void getStateForPlacement(BlockItemUseContext context, CallbackInfoReturnable<BlockState> callbackInfo) {
        if (this.canConnectDiagonally()) {
            World iblockreader = context.func_195991_k();
            BlockPos basePos = context.func_195995_a();
            FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
            BlockState placementState = super.func_196258_a(context);
            placementState = this.makeStateForPlacement(placementState, (IBlockReader)iblockreader, basePos, fluidState);
            callbackInfo.setReturnValue((Object)placementState);
        }
    }

    @Inject(method={"updatePostPlacement"}, at={@At(value="TAIL")}, cancellable=true)
    public void updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> callbackInfo) {
        BlockState returnState;
        if (this.canConnectDiagonally() && (returnState = this.updatePostPlacement2(stateIn, facing, facingState, worldIn, currentPos, facingPos, (BlockState)callbackInfo.getReturnValue())) != null) {
            callbackInfo.setReturnValue((Object)returnState);
        }
    }
}

