/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.util.math.shapes;

import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;

public class VoxelUtils {
    public static Vector3d[] scaleDown(Vector3d[] edges) {
        return VoxelUtils.scale(edges, 0.0625);
    }

    public static Vector3d[] scale(Vector3d[] edges, double amount) {
        return (Vector3d[])Stream.of(edges).map(edge -> edge.func_186678_a(amount)).toArray(Vector3d[]::new);
    }

    public static Vector3d[] flipX(Vector3d[] edges) {
        return (Vector3d[])Stream.of(edges).map(edge -> new Vector3d(16.0 - edge.field_72450_a, edge.field_72448_b, edge.field_72449_c)).toArray(Vector3d[]::new);
    }

    public static Vector3d[] flipZ(Vector3d[] edges) {
        return (Vector3d[])Stream.of(edges).map(edge -> new Vector3d(edge.field_72450_a, edge.field_72448_b, 16.0 - edge.field_72449_c)).toArray(Vector3d[]::new);
    }

    public static Vector3d[] mirror(Vector3d[] edges) {
        return VoxelUtils.flipZ(VoxelUtils.flipX(edges));
    }

    public static Vector3d[] ortho(Vector3d[] edges) {
        return (Vector3d[])Stream.of(edges).map(edge -> new Vector3d(edge.field_72449_c, edge.field_72448_b, edge.field_72450_a)).toArray(Vector3d[]::new);
    }

    public static VoxelShape makeCuboidShape(Vector3d[] outline) {
        Vector3d start = outline[0];
        Vector3d end = outline[1];
        return Block.func_208617_a((double)start.field_72450_a, (double)start.field_72448_b, (double)start.field_72449_c, (double)end.field_72450_a, (double)end.field_72448_b, (double)end.field_72449_c);
    }

    public static Vector3d[] createVectorArray(Float ... values) {
        return VoxelUtils.createVectorArray((Double[])Stream.of(values).map(Float::doubleValue).toArray(Double[]::new));
    }

    public static Vector3d[] createVectorArray(Double ... values) {
        assert (values.length % 3 == 0) : "Unable to create proper number of vectors";
        Vector3d[] array = new Vector3d[values.length / 3];
        for (int i = 0; i < array.length; ++i) {
            int index = 3 * i;
            array[i] = new Vector3d(values[index].doubleValue(), values[index + 1].doubleValue(), values[index + 2].doubleValue());
        }
        return array;
    }

    public static Vector3d[] create12Edges(Vector3d[] corners) {
        assert (corners.length == 8) : "Amount of corners must be 8";
        return new Vector3d[]{corners[0], corners[1], corners[1], corners[3], corners[3], corners[2], corners[2], corners[0], corners[0], corners[4], corners[1], corners[5], corners[2], corners[6], corners[3], corners[7], corners[4], corners[5], corners[5], corners[7], corners[7], corners[6], corners[6], corners[4]};
    }
}

