/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.api.client.render.IAccessoryRenderer;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.inferface.IColoredObject;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.model.DogModel;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.entity.accessory.ArmourAccessory;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class ArmorAccessoryRenderer
implements IAccessoryRenderer<DogEntity> {
    private final DogModel<DogEntity> model = new DogModel(0.4f);
    private ResourceLocation texture;

    public ArmorAccessoryRenderer(ResourceLocation textureIn) {
        this.texture = textureIn;
    }

    @Override
    public void render(LayerRenderer<DogEntity, EntityModel<DogEntity>> layer, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, DogEntity dog, AccessoryInstance data, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (dog.func_70909_n() && !dog.func_82150_aj()) {
            ArmourAccessory.Instance armorInstance = data.cast(ArmourAccessory.Instance.class);
            layer.func_215332_c().func_217111_a(this.model);
            this.model.setLivingAnimations(dog, limbSwing, limbSwingAmount, partialTicks);
            this.model.setRotationAngles(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.setVisible(false);
            if (armorInstance.ofType(DoggyAccessoryTypes.FEET)) {
                this.model.legBackLeft.field_78806_j = true;
                this.model.legBackRight.field_78806_j = true;
                this.model.legFrontLeft.field_78806_j = true;
                this.model.legFrontRight.field_78806_j = true;
            } else if (armorInstance.ofType(DoggyAccessoryTypes.HEAD)) {
                this.model.head.field_78806_j = true;
            } else if (armorInstance.ofType(DoggyAccessoryTypes.CLOTHING)) {
                this.model.body.field_78806_j = true;
                this.model.mane.field_78806_j = true;
            } else if (armorInstance.ofType(DoggyAccessoryTypes.TAIL)) {
                this.model.tail.field_78806_j = true;
            }
            if (armorInstance instanceof IColoredObject) {
                float[] color = ((IColoredObject)((Object)armorInstance)).getColor();
                ArmorAccessoryRenderer.renderArmorCutout(this.model, this.getTexture(dog, data), matrixStackIn, bufferIn, packedLightIn, dog, color[0], color[1], color[2], armorInstance.hasEffect());
            } else {
                ArmorAccessoryRenderer.renderArmorCutout(this.model, this.getTexture(dog, data), matrixStackIn, bufferIn, packedLightIn, dog, 1.0f, 1.0f, 1.0f, armorInstance.hasEffect());
            }
        }
    }

    public static <T extends LivingEntity> void renderArmorCutout(EntityModel<T> modelIn, ResourceLocation textureLocationIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entityIn, float red, float green, float blue, boolean enchanted) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_239263_a_((ResourceLocation)textureLocationIn), (boolean)false, (boolean)enchanted);
        modelIn.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    public <T extends AbstractDogEntity> ResourceLocation getTexture(T dog, AccessoryInstance data) {
        return this.texture;
    }
}

