/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class FindWaterGoal
extends Goal {
    private final CreatureEntity creature;
    private final PathNavigator navigator;
    private final World world;
    private final int waterSearchRange = 12;
    private final int safeSearchRange = 6;
    @Nullable
    private BlockPos waterPos;
    private int timeToRecalcPath;

    public FindWaterGoal(CreatureEntity creatureIn) {
        this.creature = creatureIn;
        this.navigator = creatureIn.func_70661_as();
        this.world = creatureIn.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.creature.func_233570_aj_() || this.creature.field_70173_aa % 5 != 0) {
            return false;
        }
        boolean isInFire = this.isInDangerSpot((Entity)this.creature);
        boolean isOnFire = this.creature.func_70027_ad();
        if (!isInFire && !isOnFire) {
            return false;
        }
        BlockPos entityPos = this.creature.func_233580_cy_();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)entityPos.func_177982_a(-this.waterSearchRange, -4, -this.waterSearchRange), (BlockPos)entityPos.func_177982_a(this.waterSearchRange, 4, this.waterSearchRange))) {
            if (this.getBlockType(pos) != BlockType.WATER) continue;
            this.waterPos = pos;
            break;
        }
        boolean waterBlockNearBy = this.waterPos != null;
        return waterBlockNearBy || isInFire;
    }

    public boolean func_75253_b() {
        if (this.waterPos != null) {
            BlockType safety = this.getBlockType(this.waterPos);
            if (safety != BlockType.WATER) {
                return false;
            }
            if (this.creature.func_70027_ad()) {
                return true;
            }
        }
        return this.isInDangerSpot((Entity)this.creature);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
    }

    public void func_75246_d() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            BlockPos targetPos = null;
            if (this.waterPos != null) {
                targetPos = this.waterPos;
            } else if (!this.creature.func_70781_l()) {
                BlockPos.Mutable mutablePos = new BlockPos.Mutable();
                for (int i = 0; i < 10; ++i) {
                    int j = EntityUtil.getRandomNumber((LivingEntity)this.creature, -this.safeSearchRange, this.safeSearchRange);
                    int k = EntityUtil.getRandomNumber((LivingEntity)this.creature, -4, 4);
                    int l = EntityUtil.getRandomNumber((LivingEntity)this.creature, -this.safeSearchRange, this.safeSearchRange);
                    mutablePos.func_189532_c(this.creature.func_226277_ct_() + (double)j, this.creature.func_226278_cu_() + (double)k, this.creature.func_226281_cx_() + (double)l);
                    boolean flag = this.getBlockType((BlockPos)mutablePos).isSafe();
                    if (!flag) continue;
                    targetPos = mutablePos;
                    break;
                }
            }
            if (targetPos != null) {
                this.navigator.func_75492_a((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), 1.2);
            }
        }
    }

    public void func_75251_c() {
        this.navigator.func_75499_g();
        this.waterPos = null;
    }

    public boolean isInDangerSpot(Entity entityIn) {
        AxisAlignedBB bb = entityIn.func_174813_aQ();
        int minX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int minY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int maxX = MathHelper.func_76143_f((double)bb.field_72336_d);
        int maxY = MathHelper.func_76143_f((double)bb.field_72337_e);
        int maxZ = MathHelper.func_76143_f((double)bb.field_72334_f);
        for (BlockPos pos : BlockPos.func_191531_b((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            BlockType safety = this.getBlockType(pos);
            if (safety != BlockType.FIRE) continue;
            return true;
        }
        return false;
    }

    public BlockType getBlockType(BlockPos posIn) {
        Material material = this.world.func_180495_p(posIn).func_185904_a();
        if (material == Material.field_151581_o || material == Material.field_151587_i) {
            return BlockType.FIRE;
        }
        if (this.world.func_204610_c(posIn).func_206884_a((ITag)FluidTags.field_206959_a)) {
            return BlockType.WATER;
        }
        if (this.world.func_175727_C(posIn)) {
            return BlockType.WATER;
        }
        return BlockType.SAFE;
    }

    public static enum BlockType {
        SAFE,
        FIRE,
        WATER;


        public boolean isSafe() {
            return this == SAFE || this == WATER;
        }
    }
}

