/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.serializers;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TalentListSerializer
implements IDataSerializer<List<TalentInstance>> {
    public void write(PacketBuffer buf, List<TalentInstance> value) {
        buf.writeInt(value.size());
        for (TalentInstance inst : value) {
            buf.writeRegistryIdUnsafe(DoggyTalentsAPI.TALENTS, (IForgeRegistryEntry)inst.getTalent());
            inst.writeToBuf(buf);
        }
    }

    public List<TalentInstance> read(PacketBuffer buf) {
        int size = buf.readInt();
        ArrayList<TalentInstance> newInst = new ArrayList<TalentInstance>(size);
        for (int i = 0; i < size; ++i) {
            TalentInstance inst = ((Talent)buf.readRegistryIdUnsafe(DoggyTalentsAPI.TALENTS)).getDefault();
            inst.readFromBuf(buf);
            newInst.add(inst);
        }
        return newInst;
    }

    public DataParameter<List<TalentInstance>> func_187161_a(int id) {
        return new DataParameter(id, (IDataSerializer)this);
    }

    public List<TalentInstance> copyValue(List<TalentInstance> value) {
        ArrayList<TalentInstance> newInst = new ArrayList<TalentInstance>(value.size());
        for (TalentInstance inst : value) {
            newInst.add(inst.copy());
        }
        return newInst;
    }
}

